/*
 * Decompiled with CFR 0.152.
 */
package net.jradius.handler.tlstunnel;

import java.io.Serializable;
import java.util.HashMap;
import java.util.StringTokenizer;
import net.jradius.exception.RadiusException;
import net.jradius.handler.RadiusSessionHandler;
import net.jradius.packet.RadiusPacket;
import net.jradius.server.JRadiusRequest;
import net.jradius.session.JRadiusSession;
import net.jradius.session.JRadiusSessionManager;
import net.jradius.session.RadiusSessionKeyProvider;
import net.jradius.session.RadiusSessionSupport;
import net.sf.ehcache.Cache;
import net.sf.ehcache.Element;

public class InitTunnelSessionHandler
extends RadiusSessionHandler {
    private Cache tlsTunnels;
    private HashMap realms = new HashMap();

    public boolean handle(JRadiusRequest request) throws RadiusException {
        int type = request.getType();
        RadiusPacket req = request.getRequestPacket();
        String fullUserName = (String)req.getAttributeValue(1L);
        String stripUserName = null;
        String realm = null;
        JRadiusSession session = request.getSession();
        if (fullUserName == null) {
            return false;
        }
        stripUserName = fullUserName;
        String[] s = RadiusSessionSupport.splitUserName((String)stripUserName);
        if (s != null && s.length == 2) {
            stripUserName = s[0];
            realm = s[1];
        }
        if (type == 2 && req.findAttribute(743440385L) != null) {
            RadiusSessionKeyProvider skp = (RadiusSessionKeyProvider)JRadiusSessionManager.getManager((Object)request.getSender()).getSessionKeyProvider(request.getSender());
            Element element = this.tlsTunnels.get(skp.getTunneledRequestKey(request));
            if (element == null) {
                return false;
            }
            String sessionKey = (String)((Object)element.getValue());
            if (sessionKey == null) {
                request.setReturnValue(0);
                return true;
            }
            session = JRadiusSessionManager.getManager((Object)request.getSender()).getSession(request, (Serializable)((Object)sessionKey));
            if (session == null) {
                throw new RadiusException("Could not find on-going tunneled session: " + sessionKey);
            }
            session.setSecured(true);
            session.setUsername(stripUserName);
            session.setRealm(realm);
            request.setSession(session);
            String r = (String)req.getAttributeValue(1045L);
            if (r != null) {
                if ("DEFAULT".equals(r)) {
                    r = realm;
                }
                if (!this.isLocalRealm(r)) {
                    session.setProxyToRealm(r);
                }
            }
        }
        return false;
    }

    public void setLocalRealms(String localRealms) {
        StringTokenizer st = new StringTokenizer(localRealms, ",");
        while (st.hasMoreTokens()) {
            String realm = st.nextToken();
            this.realms.put(realm.trim().toLowerCase(), "local");
        }
    }

    public void setSecureRealms(String localRealms) {
        StringTokenizer st = new StringTokenizer(localRealms, ",");
        while (st.hasMoreTokens()) {
            String realm = st.nextToken();
            this.realms.put(realm.trim().toLowerCase(), "secure");
        }
    }

    public boolean isLocalRealm(String realm) {
        String s = (String)this.realms.get(realm.trim().toLowerCase());
        if (s == null) {
            return false;
        }
        return "local".equals(s);
    }

    public boolean isSecureRealm(String realm) {
        String s = (String)this.realms.get(realm.trim().toLowerCase());
        if (s == null) {
            return false;
        }
        return "secure".equals(s);
    }

    public void setTlsTunnels(Cache tlsTunnels) {
        this.tlsTunnels = tlsTunnels;
    }
}

