/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.jaxb;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.opennms.core.utils.ConfigFileConstants;
import org.opennms.core.xml.JaxbUtils;
import org.opennms.netmgt.config.siteStatusViews.SiteStatusViewConfiguration;
import org.opennms.netmgt.config.siteStatusViews.View;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SiteStatusViewsFactory {
    private static final Logger LOG = LoggerFactory.getLogger(SiteStatusViewsFactory.class);
    private static SiteStatusViewsFactory m_instance;
    private static boolean m_loadedFromFile;
    protected boolean initialized = false;
    protected static long m_lastModified;
    protected static Map<String, View> m_viewsMap;
    private static SiteStatusViewConfiguration m_config;

    public SiteStatusViewsFactory(String configFile) throws IOException {
        FileInputStream stream = null;
        try {
            stream = new FileInputStream(configFile);
            this.initialize(stream);
        }
        finally {
            if (stream != null) {
                IOUtils.closeQuietly((InputStream)stream);
            }
        }
    }

    public SiteStatusViewsFactory(InputStream stream) throws IOException {
        this.initialize(stream);
    }

    private void initialize(InputStream stream) throws IOException {
        LOG.debug("initialize: initializing site status views factory.");
        try (InputStreamReader reader = new InputStreamReader(stream);){
            m_config = (SiteStatusViewConfiguration)JaxbUtils.unmarshal(SiteStatusViewConfiguration.class, (Reader)reader);
        }
        this.initializeViewsMap();
    }

    private void initializeViewsMap() {
        m_viewsMap = new HashMap<String, View>();
        for (View view : m_config.getViews()) {
            m_viewsMap.put(view.getName(), view);
        }
    }

    public static synchronized void init() throws IOException, FileNotFoundException {
        if (m_instance == null) {
            File cfgFile = ConfigFileConstants.getFile((int)ConfigFileConstants.SITE_STATUS_VIEWS_FILE_NAME);
            m_instance = new SiteStatusViewsFactory(cfgFile.getPath());
            m_lastModified = cfgFile.lastModified();
            m_loadedFromFile = true;
        }
    }

    public static synchronized SiteStatusViewsFactory getInstance() {
        if (m_instance == null) {
            throw new IllegalStateException("You must call ViewDisplay.init() before calling getInstance().");
        }
        return m_instance;
    }

    public static synchronized void setInstance(SiteStatusViewsFactory instance) {
        m_instance = instance;
        m_loadedFromFile = false;
    }

    public synchronized void reload() throws IOException, FileNotFoundException {
        m_instance = null;
        SiteStatusViewsFactory.init();
    }

    public View getView(String viewName) throws IOException {
        if (viewName == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        this.updateFromFile();
        View view = m_viewsMap.get(viewName);
        return view;
    }

    protected void updateFromFile() throws IOException {
        File siteStatusViewsFile;
        if (m_loadedFromFile && m_lastModified != (siteStatusViewsFile = ConfigFileConstants.getFile((int)ConfigFileConstants.SITE_STATUS_VIEWS_FILE_NAME)).lastModified()) {
            this.reload();
        }
    }

    public static synchronized SiteStatusViewConfiguration getConfig() {
        return m_config;
    }

    public static synchronized void setConfig(SiteStatusViewConfiguration m_config) {
        SiteStatusViewsFactory.m_config = m_config;
    }

    public static synchronized Map<String, View> getViewsMap() {
        return Collections.unmodifiableMap(m_viewsMap);
    }

    public static synchronized void setViewsMap(Map<String, View> map) {
        m_viewsMap = map;
    }

    static {
        m_loadedFromFile = false;
    }
}

