/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.timeseries.sampleread.aggregation;

import com.google.common.base.Preconditions;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringJoiner;
import org.opennms.integration.api.v1.timeseries.DataPoint;
import org.opennms.integration.api.v1.timeseries.Metric;
import org.opennms.integration.api.v1.timeseries.TimeSeriesData;
import org.opennms.integration.api.v1.timeseries.immutables.ImmutableTimeSeriesData;
import org.opennms.netmgt.measurements.model.Source;
import org.opennms.netmgt.timeseries.sampleread.LateAggregationParams;
import org.opennms.netmgt.timeseries.sampleread.aggregation.NewtsConverterUtils;
import org.opennms.newts.aggregate.ResultProcessor;
import org.opennms.newts.api.Duration;
import org.opennms.newts.api.Measurement;
import org.opennms.newts.api.Resource;
import org.opennms.newts.api.Results;
import org.opennms.newts.api.Sample;
import org.opennms.newts.api.Timestamp;
import org.opennms.newts.api.query.AggregationFunction;
import org.opennms.newts.api.query.ResultDescriptor;
import org.opennms.newts.api.query.StandardAggregationFunctions;

public class NewtsLikeSampleAggregator {
    private final Resource resource;
    private final Timestamp start;
    private final Timestamp end;
    private final ResultDescriptor resultDescriptor;
    private final List<Source> currentSources;
    private final Duration resolution;
    private final Metric metric;

    private NewtsLikeSampleAggregator(Resource resource, Timestamp start, Timestamp end, List<Source> currentSources, LateAggregationParams lag, Metric metric) {
        this.resource = (Resource)Preconditions.checkNotNull((Object)resource, (Object)"resource argument");
        this.start = (Timestamp)Preconditions.checkNotNull((Object)start, (Object)"start argument");
        this.end = (Timestamp)Preconditions.checkNotNull((Object)end, (Object)"end argument");
        this.currentSources = (List)Preconditions.checkNotNull(currentSources, (Object)"currentSources argument");
        Preconditions.checkNotNull((Object)lag, (Object)"lag argument");
        this.resultDescriptor = this.createResultDescriptor(this.currentSources, lag);
        this.resolution = Duration.millis((long)lag.getStep());
        this.metric = (Metric)Preconditions.checkNotNull((Object)metric, (Object)"metric argument");
    }

    private ResultDescriptor createResultDescriptor(List<Source> listOfSources, LateAggregationParams lag) {
        ResultDescriptor resultDescriptor = new ResultDescriptor(lag.getInterval());
        for (Source source : listOfSources) {
            String metricName = source.getDataSource() != null ? source.getDataSource() : source.getAttribute();
            String name = source.getLabel();
            AggregationFunction fn = NewtsLikeSampleAggregator.toAggregationFunction(source.getAggregation());
            resultDescriptor.datasource(name, metricName, lag.getHeartbeat(), fn);
            resultDescriptor.export(new String[]{name});
        }
        return resultDescriptor;
    }

    private static AggregationFunction toAggregationFunction(String fn) {
        if ("average".equalsIgnoreCase(fn) || "avg".equalsIgnoreCase(fn)) {
            return StandardAggregationFunctions.AVERAGE;
        }
        if ("max".equalsIgnoreCase(fn)) {
            return StandardAggregationFunctions.MAX;
        }
        if ("min".equalsIgnoreCase(fn)) {
            return StandardAggregationFunctions.MIN;
        }
        throw new IllegalArgumentException("Unsupported aggregation function: " + fn);
    }

    public static NewtsLikeSampleAggregatorBuilder builder() {
        return new NewtsLikeSampleAggregatorBuilder();
    }

    public TimeSeriesData process(Iterator<Results.Row<Sample>> samples) {
        Preconditions.checkNotNull(samples, (Object)"samples argument");
        Results measurements = new ResultProcessor(this.resource, this.start, this.end, this.resultDescriptor, this.resolution).process(samples);
        ArrayList<DataPoint> aggregatedDataPoints = new ArrayList<DataPoint>();
        for (Results.Row row : measurements) {
            aggregatedDataPoints.add(NewtsConverterUtils.toTimeSeriesDataPoint((Results.Row<Measurement>)row));
        }
        return ImmutableTimeSeriesData.builder().metric(this.metric).dataPoints(aggregatedDataPoints).build();
    }

    public static class NewtsLikeSampleAggregatorBuilder {
        private Resource resource;
        private Timestamp start;
        private Timestamp end;
        private List<Source> currentSources;
        private LateAggregationParams lateAggregationParams;
        private Metric metric;

        NewtsLikeSampleAggregatorBuilder() {
        }

        public NewtsLikeSampleAggregatorBuilder resource(String resourceId) {
            this.resource = new Resource(resourceId);
            return this;
        }

        public NewtsLikeSampleAggregatorBuilder start(Instant start) {
            this.start = Timestamp.fromEpochMillis((long)start.toEpochMilli());
            return this;
        }

        public NewtsLikeSampleAggregatorBuilder end(Instant end) {
            this.end = Timestamp.fromEpochMillis((long)end.toEpochMilli());
            return this;
        }

        public NewtsLikeSampleAggregatorBuilder currentSources(List<Source> currentSources) {
            this.currentSources = currentSources;
            return this;
        }

        public NewtsLikeSampleAggregatorBuilder lag(LateAggregationParams lateAggregationParams) {
            this.lateAggregationParams = lateAggregationParams;
            return this;
        }

        public NewtsLikeSampleAggregatorBuilder metric(Metric metric) {
            this.metric = metric;
            return this;
        }

        public NewtsLikeSampleAggregator build() {
            return new NewtsLikeSampleAggregator(this.resource, this.start, this.end, this.currentSources, this.lateAggregationParams, this.metric);
        }

        public String toString() {
            return new StringJoiner(", ", NewtsLikeSampleAggregatorBuilder.class.getSimpleName() + "[", "]").add("resource=" + this.resource).add("start=" + this.start).add("end=" + this.end).add("currentSources=" + this.currentSources).add("lateAggregationParams=" + this.lateAggregationParams).add("metric=" + this.metric).toString();
        }
    }
}

