/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.telemetry.protocols.collection;

import com.codahale.metrics.MetricRegistry;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.io.File;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Stream;
import org.opennms.core.sysprops.SystemProperties;
import org.opennms.netmgt.collection.api.CollectionAgent;
import org.opennms.netmgt.collection.api.CollectionSet;
import org.opennms.netmgt.collection.api.CollectionSetVisitor;
import org.opennms.netmgt.collection.api.Persister;
import org.opennms.netmgt.collection.api.PersisterFactory;
import org.opennms.netmgt.collection.api.ServiceParameters;
import org.opennms.netmgt.filter.api.FilterDao;
import org.opennms.netmgt.rrd.RrdRepository;
import org.opennms.netmgt.telemetry.api.adapter.TelemetryMessageLog;
import org.opennms.netmgt.telemetry.api.adapter.TelemetryMessageLogEntry;
import org.opennms.netmgt.telemetry.config.api.AdapterDefinition;
import org.opennms.netmgt.telemetry.config.api.PackageDefinition;
import org.opennms.netmgt.telemetry.protocols.collection.AbstractAdapter;
import org.opennms.netmgt.telemetry.protocols.collection.CollectionSetWithAgent;
import org.opennms.netmgt.threshd.api.ThresholdInitializationException;
import org.opennms.netmgt.threshd.api.ThresholdingService;
import org.opennms.netmgt.threshd.api.ThresholdingSession;
import org.osgi.framework.BundleContext;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractCollectionAdapter
extends AbstractAdapter {
    private static final ServiceParameters EMPTY_SERVICE_PARAMETERS = new ServiceParameters(Collections.emptyMap());
    private final LoadingCache<CacheKey, Optional<PackageDefinition>> cache = CacheBuilder.newBuilder().maximumSize(SystemProperties.getLong((String)"org.opennms.features.telemetry.cache.ipAddressFilter.maximumSize", (int)1000).longValue()).expireAfterWrite(SystemProperties.getLong((String)"org.opennms.features.telemetry.cache.ipAddressFilter.expireAfterWrite", (int)120).longValue(), TimeUnit.SECONDS).build((CacheLoader)new CacheLoader<CacheKey, Optional<PackageDefinition>>(){

        public Optional<PackageDefinition> load(CacheKey key) {
            for (PackageDefinition pkg : AbstractCollectionAdapter.this.adapterConfig.getPackages()) {
                String filterRule = pkg.getFilterRule();
                if (filterRule == null) {
                    return Optional.of(pkg);
                }
                if (!AbstractCollectionAdapter.this.filterDao.isValid(key.getHostAddress(), pkg.getFilterRule())) continue;
                return Optional.of(pkg);
            }
            return Optional.empty();
        }
    });
    protected BundleContext bundleContext;
    @Autowired
    private FilterDao filterDao;
    @Autowired
    private PersisterFactory persisterFactory;
    @Autowired
    private ThresholdingService thresholdingService;
    private AtomicBoolean isThresholdingEnabled = new AtomicBoolean(true);
    private Integer thresholdingSessionTtlMinutes = SystemProperties.getInteger((String)"org.opennms.netmgt.telemetry.protocols.collection.thresholdingSessionTtlMinutes", (int)1440);
    private Cache<String, ThresholdingSession> agentThresholdingSessions = CacheBuilder.newBuilder().expireAfterAccess((long)this.thresholdingSessionTtlMinutes.intValue(), TimeUnit.MINUTES).build();

    public AbstractCollectionAdapter(AdapterDefinition adapterConfig, MetricRegistry metricRegistry) {
        super(adapterConfig, metricRegistry);
    }

    public abstract Stream<CollectionSetWithAgent> handleCollectionMessage(TelemetryMessageLogEntry var1, TelemetryMessageLog var2);

    @Override
    public final void handleMessage(TelemetryMessageLogEntry message, TelemetryMessageLog messageLog) {
        this.handleCollectionMessage(message, messageLog).forEach(result -> {
            PackageDefinition pkg = this.getPackageFor(this.adapterConfig, result.getAgent());
            if (pkg == null) {
                this.LOG.warn("No matching package found for message: {}. Dropping.", (Object)message);
                return;
            }
            RrdRepository repository = new RrdRepository();
            repository.setStep(pkg.getRrd().getStep().intValue());
            repository.setHeartBeat(repository.getStep() * 2);
            repository.setRraList(pkg.getRrd().getRras());
            repository.setRrdBaseDir(new File(pkg.getRrd().getBaseDir()));
            CollectionSet collectionSet = result.getCollectionSet();
            this.LOG.trace("Persisting collection set: {} for message: {}", (Object)collectionSet, (Object)message);
            Persister persister = this.persisterFactory.createPersister(EMPTY_SERVICE_PARAMETERS, repository);
            collectionSet.visit((CollectionSetVisitor)persister);
            try {
                if (this.isThresholdingEnabled.get()) {
                    ThresholdingSession session = this.getSessionForAgent(result.getAgent());
                    session.accept(collectionSet);
                }
            }
            catch (ThresholdInitializationException e) {
                this.LOG.warn("Failed Thresholding of CollectionSet : {} for agent: {}", (Object)e.getMessage(), (Object)result.getAgent());
            }
        });
    }

    private ThresholdingSession getSessionForAgent(CollectionAgent agent) throws ThresholdInitializationException {
        String serviceName;
        String hostAddress;
        if (this.thresholdingService == null) {
            this.isThresholdingEnabled.set(false);
            throw new ThresholdInitializationException("No ThresholdingService available. No future Threshholding will be done");
        }
        int nodeId = agent.getNodeId();
        String sessionKey = this.getSessionKey(nodeId, hostAddress = agent.getHostAddress(), serviceName = this.adapterConfig.getName());
        ThresholdingSession session = (ThresholdingSession)this.agentThresholdingSessions.getIfPresent((Object)sessionKey);
        if (session == null) {
            session = this.thresholdingService.createSession(nodeId, hostAddress, serviceName, EMPTY_SERVICE_PARAMETERS);
            this.agentThresholdingSessions.put((Object)sessionKey, (Object)session);
        }
        return session;
    }

    private String getSessionKey(int nodeId, String hostAddress, String serviceName) {
        return String.valueOf(nodeId) + hostAddress + serviceName;
    }

    private PackageDefinition getPackageFor(AdapterDefinition protocol, CollectionAgent agent) {
        try {
            Optional value = (Optional)this.cache.get((Object)new CacheKey(protocol.getName(), agent.getHostAddress()));
            return value.orElse(null);
        }
        catch (ExecutionException e) {
            this.LOG.error("Error while retrieving package from Cache: {}.", (Object)e.getMessage(), (Object)e);
            throw new RuntimeException(e);
        }
    }

    public void setFilterDao(FilterDao filterDao) {
        this.filterDao = filterDao;
    }

    public void setPersisterFactory(PersisterFactory persisterFactory) {
        this.persisterFactory = persisterFactory;
    }

    public ThresholdingService getThresholdingService() {
        return this.thresholdingService;
    }

    public void setThresholdingService(ThresholdingService thresholdingService) {
        this.thresholdingService = thresholdingService;
    }

    public void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    private static class CacheKey {
        private String protocol;
        private String hostAddress;

        public CacheKey(String protocol, String hostAddress) {
            this.protocol = Objects.requireNonNull(protocol);
            this.hostAddress = Objects.requireNonNull(hostAddress);
        }

        public String getProtocol() {
            return this.protocol;
        }

        public String getHostAddress() {
            return this.hostAddress;
        }

        public int hashCode() {
            return Objects.hash(this.hostAddress, this.protocol);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CacheKey cacheKey = (CacheKey)o;
            boolean equals = Objects.equals(this.hostAddress, cacheKey.hostAddress) && Objects.equals(this.protocol, cacheKey.protocol);
            return equals;
        }
    }
}

