/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.model.snmpmetadata;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.opennms.netmgt.model.snmpmetadata.SnmpMetadataBase;
import org.opennms.netmgt.model.snmpmetadata.SnmpMetadataValue;

@XmlRootElement(name="snmp-metadata-entry")
public class SnmpMetadataEntry
extends SnmpMetadataBase {
    private String index;
    private List<SnmpMetadataValue> values = new ArrayList<SnmpMetadataValue>();

    public SnmpMetadataEntry() {
    }

    public SnmpMetadataEntry(String index) {
        this.index = index;
    }

    @XmlAttribute(name="index")
    public String getIndex() {
        return this.index;
    }

    public void setIndex(String index) {
        this.index = index;
    }

    @XmlElement(name="snmp-metadata-value")
    public List<SnmpMetadataValue> getValues() {
        return this.values;
    }

    public void setValues(List<SnmpMetadataValue> values) {
        this.values = values;
    }

    public SnmpMetadataValue addValue(String name, String value) {
        SnmpMetadataValue snmpMetadataValue;
        Optional<SnmpMetadataValue> optionalEntry = this.values.stream().filter(e -> this.trimName(name).equals(e.getName())).findAny();
        if (optionalEntry.isPresent()) {
            snmpMetadataValue = optionalEntry.get();
        } else {
            snmpMetadataValue = new SnmpMetadataValue(name);
            snmpMetadataValue.setParent(this);
            this.values.add(snmpMetadataValue);
        }
        snmpMetadataValue.setValue(value);
        return snmpMetadataValue;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SnmpMetadataEntry that = (SnmpMetadataEntry)o;
        return Objects.equals(this.index, that.index) && Objects.equals(this.values, that.values);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.index, this.values);
    }
}

