/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.opennms.netmgt.model.ExternalValueAttribute;
import org.opennms.netmgt.model.OnmsAttribute;
import org.opennms.netmgt.model.OnmsEntity;
import org.opennms.netmgt.model.OnmsResourceType;
import org.opennms.netmgt.model.ResourceId;
import org.opennms.netmgt.model.ResourcePath;
import org.opennms.netmgt.model.RrdGraphAttribute;
import org.opennms.netmgt.model.StringPropertyAttribute;
import org.springframework.util.Assert;

public class OnmsResource
implements Comparable<OnmsResource> {
    private final String m_name;
    private final Set<OnmsAttribute> m_attributes;
    private final OnmsResourceType m_resourceType;
    private final List<OnmsResource> m_resources;
    private final ResourcePath m_path;
    private String m_label;
    private String m_link;
    private OnmsEntity m_entity;
    private OnmsResource m_parent = null;
    private boolean m_attributesUpdatedWithResource = false;

    public OnmsResource(String name, String label, OnmsResourceType resourceType, Set<OnmsAttribute> attributes, ResourcePath path) {
        this(name, label, resourceType, attributes, new ArrayList<OnmsResource>(0), path);
    }

    public OnmsResource(String name, String label, OnmsResourceType resourceType, Set<OnmsAttribute> attributes, List<OnmsResource> resources, ResourcePath path) {
        Assert.notNull((Object)name, (String)"name argument must not be null");
        Assert.notNull((Object)label, (String)"label argument must not be null");
        Assert.notNull((Object)resourceType, (String)"resourceType argument must not be null");
        Assert.notNull(attributes, (String)"attributes argument must not be null");
        Assert.notNull(resources, (String)"resources argument must not be null");
        Assert.notNull((Object)path, (String)"path argument must not be null");
        this.m_name = name;
        this.m_label = label;
        this.m_resourceType = resourceType;
        this.m_attributes = attributes;
        this.m_resources = resources;
        this.m_path = path;
    }

    public String getName() {
        return this.m_name;
    }

    public String getLabel() {
        return this.m_label;
    }

    public void setLabel(String label) {
        this.m_label = label;
    }

    public OnmsResourceType getResourceType() {
        return this.m_resourceType;
    }

    public Set<OnmsAttribute> getAttributes() {
        if (!this.m_attributesUpdatedWithResource) {
            for (OnmsAttribute attribute : this.m_attributes) {
                attribute.setResource(this);
            }
            this.m_attributesUpdatedWithResource = true;
        }
        return this.m_attributes;
    }

    public List<OnmsResource> getChildResources() {
        return this.m_resources;
    }

    @Override
    public int compareTo(OnmsResource o) {
        return this.getLabel().compareTo(o.getLabel());
    }

    public static List<OnmsResource> sortIntoResourceList(List<OnmsResource> resources) {
        Collections.sort(resources);
        ArrayList<OnmsResource> outputResources = new ArrayList<OnmsResource>(resources.size());
        for (OnmsResource resource : resources) {
            outputResources.add(resource);
        }
        return outputResources;
    }

    public void setParent(OnmsResource parent) {
        this.m_parent = parent;
    }

    public OnmsResource getParent() {
        return this.m_parent;
    }

    public ResourceId getId() {
        if (this.getParent() != null) {
            return this.getParent().getId().resolve(this.getResourceType().getName(), this.getName());
        }
        return ResourceId.get(this.getResourceType().getName(), this.getName());
    }

    public String getLink() {
        if (this.m_link != null) {
            return this.m_link;
        }
        return this.m_resourceType.getLinkForResource(this);
    }

    public void setLink(String link) {
        this.m_link = link;
    }

    public Map<String, RrdGraphAttribute> getRrdGraphAttributes() {
        HashMap<String, RrdGraphAttribute> attributes = new HashMap<String, RrdGraphAttribute>();
        for (OnmsAttribute attribute : this.getAttributes()) {
            if (!RrdGraphAttribute.class.isAssignableFrom(attribute.getClass())) continue;
            RrdGraphAttribute graphAttribute = (RrdGraphAttribute)attribute;
            attributes.put(graphAttribute.getName(), graphAttribute);
        }
        return attributes;
    }

    public Map<String, String> getStringPropertyAttributes() {
        HashMap<String, String> properties = new HashMap<String, String>();
        for (OnmsAttribute attribute : this.getAttributes()) {
            if (!StringPropertyAttribute.class.isAssignableFrom(attribute.getClass())) continue;
            StringPropertyAttribute stringAttribute = (StringPropertyAttribute)attribute;
            properties.put(stringAttribute.getName(), stringAttribute.getValue());
        }
        return properties;
    }

    public Map<String, String> getExternalValueAttributes() {
        HashMap<String, String> properties = new HashMap<String, String>();
        for (OnmsAttribute attribute : this.getAttributes()) {
            if (!ExternalValueAttribute.class.isAssignableFrom(attribute.getClass())) continue;
            ExternalValueAttribute externalValueAttribute = (ExternalValueAttribute)attribute;
            properties.put(externalValueAttribute.getName(), externalValueAttribute.getValue());
        }
        return properties;
    }

    public String toString() {
        return this.getId().toString();
    }

    public OnmsEntity getEntity() {
        return this.m_entity;
    }

    public void setEntity(OnmsEntity entity) {
        this.m_entity = entity;
    }

    public ResourcePath getPath() {
        return this.m_path;
    }
}

