/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.commands;

import java.io.FileOutputStream;
import java.util.Collections;
import javax.management.MBeanServerConnection;
import javax.management.MBeanServerInvocationHandler;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.apache.karaf.shell.api.action.Action;
import org.apache.karaf.shell.api.action.Argument;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.opennms.core.commands.IJaCoCoProxy;
import org.opennms.core.daemon.CurrentVirtualMachine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Command(scope="jacoco", name="dump", description="Trigger a code-coverage dump using the JMX agent interface.")
@Service
public class CoverageCommand
implements Action {
    private static final Logger LOG = LoggerFactory.getLogger(CoverageCommand.class);
    private static final String DEFAULT_SERVICE_URL = "service:jmx:rmi:///jndi/rmi://127.0.0.1:1099/jmxrmi";
    @Argument(index=0, name="file", description="the file to dump (defaults to jacoco.exec)", required=false)
    private String m_file = "jacoco.exec";

    /*
     * Enabled aggressive exception aggregation
     */
    public Object execute() {
        JMXServiceURL url = null;
        String jmxUrlString = this.getJmxUrl();
        try {
            url = new JMXServiceURL(jmxUrlString);
        }
        catch (Exception j) {
            LOG.debug("failed to initialize JMX service URL {}", (Object)jmxUrlString, (Object)j);
            return null;
        }
        try (JMXConnector jmxc = JMXConnectorFactory.connect(url, Collections.emptyMap());){
            Object var8_14;
            try (FileOutputStream output = new FileOutputStream(this.m_file);){
                MBeanServerConnection connection = jmxc.getMBeanServerConnection();
                IJaCoCoProxy proxy = MBeanServerInvocationHandler.newProxyInstance(connection, new ObjectName("org.jacoco:type=Runtime"), IJaCoCoProxy.class, false);
                System.out.println("JaCoCo Version: " + proxy.getVersion());
                System.out.println("Session ID: " + proxy.getSessionId());
                System.out.println("Dumping execution data to " + this.m_file + "...");
                byte[] data = proxy.getExecutionData(false);
                output.write(data);
                System.out.println("Wrote " + data.length + " bytes.");
                var8_14 = null;
            }
            return var8_14;
        }
        catch (Exception e) {
            LOG.debug("failed to connect to JMX", (Throwable)e);
            return null;
        }
    }

    private String getJmxUrl() {
        try {
            return CurrentVirtualMachine.getJmxUri();
        }
        catch (IllegalStateException e) {
            LOG.info("falling back to JMX over RMI (this probably won't work)", (Throwable)e);
            return DEFAULT_SERVICE_URL;
        }
    }
}

