/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.rest.v2;

import com.google.common.collect.Sets;
import io.swagger.v3.oas.annotations.Operation;
import java.net.InetAddress;
import java.net.URI;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.PathSegment;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;
import org.opennms.core.config.api.JaxbListWrapper;
import org.opennms.core.criteria.Alias;
import org.opennms.core.criteria.CriteriaBuilder;
import org.opennms.netmgt.dao.api.MonitoredServiceDao;
import org.opennms.netmgt.dao.api.ServiceTypeDao;
import org.opennms.netmgt.dao.support.CreateIfNecessaryTemplate;
import org.opennms.netmgt.model.OnmsApplication;
import org.opennms.netmgt.model.OnmsIpInterface;
import org.opennms.netmgt.model.OnmsMetaData;
import org.opennms.netmgt.model.OnmsMetaDataList;
import org.opennms.netmgt.model.OnmsMonitoredService;
import org.opennms.netmgt.model.OnmsMonitoredServiceList;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.OnmsServiceType;
import org.opennms.netmgt.model.events.EventUtils;
import org.opennms.netmgt.xml.event.Event;
import org.opennms.web.api.RestUtils;
import org.opennms.web.rest.support.Aliases;
import org.opennms.web.rest.support.MultivaluedMapImpl;
import org.opennms.web.rest.support.RedirectHelper;
import org.opennms.web.rest.v2.AbstractNodeDependentRestService;
import org.opennms.web.rest.v2.ApplicationEventUtil;
import org.opennms.web.rest.v2.MonitoredServicesComponent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.annotation.Transactional;

@Component
@Transactional
public class NodeMonitoredServiceRestService
extends AbstractNodeDependentRestService<OnmsMonitoredService, OnmsMonitoredService, Integer, String> {
    private static final Logger LOG = LoggerFactory.getLogger(NodeMonitoredServiceRestService.class);
    @Autowired
    private PlatformTransactionManager m_transactionManager;
    @Autowired
    private ServiceTypeDao m_serviceTypeDao;
    @Autowired
    private MonitoredServicesComponent m_component;
    @Autowired
    private MonitoredServiceDao m_dao;

    protected MonitoredServiceDao getDao() {
        return this.m_dao;
    }

    @Override
    protected Class<OnmsMonitoredService> getDaoClass() {
        return OnmsMonitoredService.class;
    }

    @Override
    protected Class<OnmsMonitoredService> getQueryBeanClass() {
        return OnmsMonitoredService.class;
    }

    @Override
    protected CriteriaBuilder getCriteriaBuilder(UriInfo uriInfo) {
        CriteriaBuilder builder = new CriteriaBuilder(this.getDaoClass());
        builder.alias("ipInterface", Aliases.ipInterface.toString(), Alias.JoinType.LEFT_JOIN);
        builder.alias("serviceType", Aliases.serviceType.toString(), Alias.JoinType.LEFT_JOIN);
        builder.alias("ipInterface.node", Aliases.node.toString(), Alias.JoinType.LEFT_JOIN);
        builder.alias("ipInterface.snmpInterface", Aliases.snmpInterface.toString(), Alias.JoinType.LEFT_JOIN);
        builder.alias("node.assetRecord", Aliases.assetRecord.toString(), Alias.JoinType.LEFT_JOIN);
        builder.alias("node.categories", Aliases.category.toString(), Alias.JoinType.LEFT_JOIN);
        builder.alias("node.location", Aliases.location.toString(), Alias.JoinType.LEFT_JOIN);
        builder.orderBy("id");
        this.updateCriteria(uriInfo, builder);
        return builder;
    }

    @Override
    protected JaxbListWrapper<OnmsMonitoredService> createListWrapper(Collection<OnmsMonitoredService> list) {
        return new OnmsMonitoredServiceList(list);
    }

    @Override
    protected Response doCreate(SecurityContext securityContext, UriInfo uriInfo, OnmsMonitoredService service) {
        OnmsIpInterface iface = this.getInterface(uriInfo);
        if (iface == null) {
            throw NodeMonitoredServiceRestService.getException(Response.Status.BAD_REQUEST, "IP interface was not found", new String[0]);
        }
        if (service == null) {
            throw NodeMonitoredServiceRestService.getException(Response.Status.BAD_REQUEST, "Service object cannot be null", new String[0]);
        }
        if (service.getServiceType() == null || service.getServiceType().getName() == null) {
            throw NodeMonitoredServiceRestService.getException(Response.Status.BAD_REQUEST, "Service type names cannot be null", new String[0]);
        }
        service.setServiceType(this.getServiceType(service.getServiceName()));
        service.setIpInterface(iface);
        iface.addMonitoredService(service);
        this.getDao().save((Object)service);
        Event e = EventUtils.createNodeGainedServiceEvent((String)"ReST", (int)iface.getNode().getId(), (InetAddress)iface.getIpAddress(), (String)service.getServiceName(), (String)iface.getNode().getLabel(), (OnmsNode.NodeLabelSource)iface.getNode().getLabelSource(), (String)iface.getNode().getSysName(), (String)iface.getNode().getSysDescription());
        this.sendEvent(e);
        ApplicationEventUtil.getApplicationChangedEvents(service.getApplications()).forEach(this::sendEvent);
        return Response.created((URI)RedirectHelper.getRedirectUri(uriInfo, service.getServiceName())).build();
    }

    @Override
    protected void updateCriteria(UriInfo uriInfo, CriteriaBuilder builder) {
        super.updateCriteria(uriInfo, builder);
        List segments = uriInfo.getPathSegments(true);
        String ipAddress = ((PathSegment)segments.get(3)).getPath();
        builder.eq("ipInterface.ipAddress", (Object)ipAddress);
    }

    @Override
    protected Response doUpdateProperties(SecurityContext securityContext, UriInfo uriInfo, OnmsMonitoredService targetObject, MultivaluedMapImpl params) {
        String previousStatus = targetObject.getStatus();
        HashSet applicationsOriginal = new HashSet();
        if (targetObject.getApplications() != null) {
            applicationsOriginal.addAll(targetObject.getApplications());
        }
        RestUtils.setBeanProperties((Object)targetObject, (MultivaluedMap)params);
        this.getDao().update((Object)targetObject);
        Sets.SetView changedApplications = Sets.symmetricDifference(applicationsOriginal, (Set)targetObject.getApplications());
        ApplicationEventUtil.getApplicationChangedEvents((Collection<OnmsApplication>)changedApplications).forEach(this::sendEvent);
        boolean changed = this.m_component.hasStatusChanged(previousStatus, targetObject);
        return changed ? Response.noContent().build() : Response.notModified().build();
    }

    @Override
    protected void doDelete(SecurityContext securityContext, UriInfo uriInfo, OnmsMonitoredService svc) {
        svc.getIpInterface().getMonitoredServices().remove(svc);
        this.getDao().delete((Object)svc);
        Event e = EventUtils.createDeleteServiceEvent((String)"ReST", (long)svc.getNodeId().intValue(), (String)svc.getIpAddress().getHostAddress(), (String)svc.getServiceName(), (long)-1L);
        this.sendEvent(e);
        ApplicationEventUtil.getApplicationChangedEvents(svc.getApplications()).forEach(this::sendEvent);
    }

    @Override
    protected OnmsMonitoredService doGet(UriInfo uriInfo, String serviceName) {
        OnmsIpInterface iface = this.getInterface(uriInfo);
        return iface == null ? null : iface.getMonitoredServiceByServiceType(serviceName);
    }

    private OnmsServiceType getServiceType(final String serviceName) {
        OnmsServiceType serviceType = (OnmsServiceType)new CreateIfNecessaryTemplate<OnmsServiceType, ServiceTypeDao>(this.m_transactionManager, this.m_serviceTypeDao){

            protected OnmsServiceType query() {
                return ((ServiceTypeDao)this.m_dao).findByName(serviceName);
            }

            protected OnmsServiceType doInsert() {
                LOG.info("getServiceType: creating service type {}", (Object)serviceName);
                OnmsServiceType s = new OnmsServiceType(serviceName);
                ((ServiceTypeDao)this.m_dao).saveOrUpdate((Object)s);
                return s;
            }
        }.execute();
        return serviceType;
    }

    private OnmsIpInterface getInterface(UriInfo uriInfo) {
        OnmsNode node = this.getNode(uriInfo);
        String ipAddress = ((PathSegment)uriInfo.getPathSegments(true).get(3)).getPath();
        return node == null ? null : node.getIpInterfaceByIpAddress(ipAddress);
    }

    protected OnmsMonitoredService getService(UriInfo uriInfo, String serviceName) {
        OnmsIpInterface iface = this.getInterface(uriInfo);
        return iface == null ? null : iface.getMonitoredServiceByServiceType(serviceName);
    }

    @GET
    @Path(value="{serviceName}/metadata")
    @Produces(value={"application/json", "application/xml", "application/atom+xml"})
    @Operation(summary="Get metadata by service", description="Get metadata by service", operationId="NodeMonitoredServiceRestServiceGetMetaDataByService")
    public OnmsMetaDataList getMetaData(@Context UriInfo uriInfo, @PathParam(value="serviceName") String serviceName) {
        OnmsMonitoredService service = this.getService(uriInfo, serviceName);
        if (serviceName == null) {
            throw NodeMonitoredServiceRestService.getException(Response.Status.BAD_REQUEST, "getMetaData: Can't find service " + serviceName, new String[0]);
        }
        return new OnmsMetaDataList((Collection)service.getMetaData());
    }

    @GET
    @Path(value="{serviceName}/metadata/{context}")
    @Produces(value={"application/json", "application/xml", "application/atom+xml"})
    @Operation(summary="Get metadata by service and context", description="Get metadata by service and context", operationId="NodeMonitoredServiceRestServiceGetMetaDataByServiceAndContext")
    public OnmsMetaDataList getMetaData(@Context UriInfo uriInfo, @PathParam(value="serviceName") String serviceName, @PathParam(value="context") String context) {
        OnmsMonitoredService service = this.getService(uriInfo, serviceName);
        if (serviceName == null) {
            throw NodeMonitoredServiceRestService.getException(Response.Status.BAD_REQUEST, "getMetaData: Can't find service " + serviceName, new String[0]);
        }
        return new OnmsMetaDataList((Collection)service.getMetaData().stream().filter(e -> context.equals(e.getContext())).collect(Collectors.toList()));
    }

    @GET
    @Path(value="{serviceName}/metadata/{context}/{key}")
    @Produces(value={"application/json", "application/xml", "application/atom+xml"})
    @Operation(summary="Get metadata by service, context and key", description="Get metadata by service, context and key", operationId="NodeMonitoredServiceRestServiceGetMetaDataByServiceAndContextAndKey")
    public OnmsMetaDataList getMetaData(@Context UriInfo uriInfo, @PathParam(value="serviceName") String serviceName, @PathParam(value="context") String context, @PathParam(value="key") String key) {
        OnmsMonitoredService service = this.getService(uriInfo, serviceName);
        if (serviceName == null) {
            throw NodeMonitoredServiceRestService.getException(Response.Status.BAD_REQUEST, "getMetaData: Can't find service " + serviceName, new String[0]);
        }
        return new OnmsMetaDataList((Collection)service.getMetaData().stream().filter(e -> context.equals(e.getContext()) && key.equals(e.getKey())).collect(Collectors.toList()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @DELETE
    @Path(value="{serviceName}/metadata/{context}")
    @Produces(value={"application/json", "application/xml", "application/atom+xml"})
    public Response deleteMetaData(@Context UriInfo uriInfo, @PathParam(value="serviceName") String serviceName, @PathParam(value="context") String context) {
        NodeMonitoredServiceRestService.checkUserDefinedMetadataContext(context);
        this.writeLock();
        try {
            OnmsMonitoredService service = this.getService(uriInfo, serviceName);
            if (serviceName == null) {
                throw NodeMonitoredServiceRestService.getException(Response.Status.BAD_REQUEST, "deleteMetaData: Can't find service " + serviceName, new String[0]);
            }
            service.removeMetaData(context);
            this.getDao().update((Object)service);
            Response response = Response.noContent().build();
            return response;
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @DELETE
    @Path(value="{serviceName}/metadata/{context}/{key}")
    @Produces(value={"application/json", "application/xml", "application/atom+xml"})
    public Response deleteMetaData(@Context UriInfo uriInfo, @PathParam(value="serviceName") String serviceName, @PathParam(value="context") String context, @PathParam(value="key") String key) {
        NodeMonitoredServiceRestService.checkUserDefinedMetadataContext(context);
        this.writeLock();
        try {
            OnmsMonitoredService service = this.getService(uriInfo, serviceName);
            if (serviceName == null) {
                throw NodeMonitoredServiceRestService.getException(Response.Status.BAD_REQUEST, "deleteMetaData: Can't find service " + serviceName, new String[0]);
            }
            service.removeMetaData(context, key);
            this.getDao().update((Object)service);
            Response response = Response.noContent().build();
            return response;
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Path(value="{serviceName}/metadata")
    @Produces(value={"application/json", "application/xml", "application/atom+xml"})
    public Response postMetaData(@Context UriInfo uriInfo, @PathParam(value="serviceName") String serviceName, OnmsMetaData entity) {
        NodeMonitoredServiceRestService.checkUserDefinedMetadataContext(entity.getContext());
        this.writeLock();
        try {
            OnmsMonitoredService service = this.getService(uriInfo, serviceName);
            if (serviceName == null) {
                throw NodeMonitoredServiceRestService.getException(Response.Status.BAD_REQUEST, "postMetaData: Can't find service " + serviceName, new String[0]);
            }
            service.addMetaData(entity.getContext(), entity.getKey(), entity.getValue());
            this.getDao().update((Object)service);
            Response response = Response.noContent().build();
            return response;
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PUT
    @Path(value="{serviceName}/metadata/{context}/{key}/{value}")
    @Produces(value={"application/json", "application/xml", "application/atom+xml"})
    public Response putMetaData(@Context UriInfo uriInfo, @PathParam(value="serviceName") String serviceName, @PathParam(value="context") String context, @PathParam(value="key") String key, @PathParam(value="value") String value) {
        NodeMonitoredServiceRestService.checkUserDefinedMetadataContext(context);
        this.writeLock();
        try {
            OnmsMonitoredService service = this.getService(uriInfo, serviceName);
            if (serviceName == null) {
                throw NodeMonitoredServiceRestService.getException(Response.Status.BAD_REQUEST, "putMetaData: Can't find service " + serviceName, new String[0]);
            }
            service.addMetaData(context, key, value);
            this.getDao().update((Object)service);
            Response response = Response.noContent().build();
            return response;
        }
        finally {
            this.writeUnlock();
        }
    }
}

