/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.telemetry.protocols.flows;

import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import com.google.common.base.Strings;
import java.time.Instant;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import org.opennms.core.mate.api.ContextKey;
import org.opennms.integration.api.v1.flows.FlowException;
import org.opennms.netmgt.flows.api.DetailedFlowException;
import org.opennms.netmgt.flows.api.Flow;
import org.opennms.netmgt.flows.api.FlowSource;
import org.opennms.netmgt.flows.api.UnrecoverableFlowException;
import org.opennms.netmgt.flows.processing.Pipeline;
import org.opennms.netmgt.flows.processing.ProcessingOptions;
import org.opennms.netmgt.telemetry.api.adapter.Adapter;
import org.opennms.netmgt.telemetry.api.adapter.TelemetryMessageLog;
import org.opennms.netmgt.telemetry.api.adapter.TelemetryMessageLogEntry;
import org.opennms.netmgt.telemetry.config.api.AdapterDefinition;
import org.opennms.netmgt.telemetry.config.api.PackageDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractFlowAdapter<P>
implements Adapter {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractFlowAdapter.class);
    private final Pipeline pipeline;
    private String metaDataNodeLookup;
    private ContextKey contextKey;
    private final Timer logParsingTimer;
    private final Histogram packetsPerLogHistogram;
    private final Meter entriesReceived;
    private final Meter entriesParsed;
    private final Meter entriesConverted;
    private boolean applicationThresholding;
    private boolean applicationDataCollection;
    private final List<? extends PackageDefinition> packages;

    public AbstractFlowAdapter(AdapterDefinition adapterConfig, MetricRegistry metricRegistry, Pipeline pipeline) {
        Objects.requireNonNull(adapterConfig);
        Objects.requireNonNull(metricRegistry);
        this.pipeline = Objects.requireNonNull(pipeline);
        this.logParsingTimer = metricRegistry.timer(MetricRegistry.name((String)"adapters", (String[])new String[]{adapterConfig.getFullName(), "logParsing"}));
        this.packetsPerLogHistogram = metricRegistry.histogram(MetricRegistry.name((String)"adapters", (String[])new String[]{adapterConfig.getFullName(), "packetsPerLog"}));
        this.entriesReceived = metricRegistry.meter(MetricRegistry.name((String)"adapters", (String[])new String[]{adapterConfig.getFullName(), "entriesReceived"}));
        this.entriesParsed = metricRegistry.meter(MetricRegistry.name((String)"adapters", (String[])new String[]{adapterConfig.getFullName(), "entriesParsed"}));
        this.entriesConverted = metricRegistry.meter(MetricRegistry.name((String)"adapters", (String[])new String[]{adapterConfig.getFullName(), "entriesConverted"}));
        this.packages = Objects.requireNonNull(adapterConfig.getPackages());
    }

    public void handleMessageLog(TelemetryMessageLog messageLog) {
        LOG.debug("Received {} telemetry messages", (Object)messageLog.getMessageList().size());
        int flowPackets = 0;
        LinkedList<Flow> flows = new LinkedList<Flow>();
        try (Timer.Context ctx = this.logParsingTimer.time();){
            for (TelemetryMessageLogEntry eachMessage : messageLog.getMessageList()) {
                this.entriesReceived.mark();
                LOG.trace("Parsing packet: {}", (Object)eachMessage);
                P flowPacket = this.parse(eachMessage);
                if (flowPacket == null) continue;
                this.entriesParsed.mark();
                ++flowPackets;
                List<Flow> converted = this.convert(flowPacket, Instant.ofEpochMilli(eachMessage.getTimestamp()));
                flows.addAll(converted);
                this.entriesConverted.mark((long)converted.size());
            }
            this.packetsPerLogHistogram.update(flowPackets);
        }
        try {
            LOG.debug("Persisting {} packets, {} flows.", (Object)flowPackets, (Object)flows.size());
            FlowSource source = new FlowSource(messageLog.getLocation(), messageLog.getSourceAddress(), this.contextKey);
            this.pipeline.process(flows, source, ProcessingOptions.builder().setApplicationThresholding(this.applicationThresholding).setApplicationDataCollection(this.applicationDataCollection).setPackages(this.packages).build());
        }
        catch (DetailedFlowException ex) {
            LOG.error("Error while persisting flows: {}", (Object)ex.getMessage(), (Object)ex);
            for (String logMessage : ex.getDetailedLogMessages()) {
                LOG.error(logMessage);
            }
        }
        catch (UnrecoverableFlowException ex) {
            LOG.error("Error while persisting flows. Cannot recover: {}. {} messages are lost.", new Object[]{ex.getMessage(), messageLog.getMessageList().size(), ex});
            return;
        }
        catch (FlowException ex) {
            LOG.error("Error while persisting flows: {}", (Object)ex.getMessage(), (Object)ex);
        }
        LOG.debug("Completed processing {} telemetry messages.", (Object)messageLog.getMessageList().size());
    }

    protected abstract P parse(TelemetryMessageLogEntry var1);

    protected abstract List<Flow> convert(P var1, Instant var2);

    public void destroy() {
    }

    public String getMetaDataNodeLookup() {
        return this.metaDataNodeLookup;
    }

    public void setMetaDataNodeLookup(String metaDataNodeLookup) {
        this.metaDataNodeLookup = metaDataNodeLookup;
        this.contextKey = !Strings.isNullOrEmpty((String)this.metaDataNodeLookup) ? new ContextKey(metaDataNodeLookup) : null;
    }

    public boolean isApplicationThresholding() {
        return this.applicationThresholding;
    }

    public void setApplicationThresholding(boolean applicationThresholding) {
        this.applicationThresholding = applicationThresholding;
    }

    public boolean isApplicationDataCollection() {
        return this.applicationDataCollection;
    }

    public void setApplicationDataCollection(boolean applicationDataCollection) {
        this.applicationDataCollection = applicationDataCollection;
    }
}

