/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.oai.validator.report;

import com.atlassian.oai.validator.report.ValidationReport;
import com.atlassian.oai.validator.report.ValidationReportFormat;
import com.atlassian.oai.validator.util.StringUtils;
import java.util.Arrays;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class SimpleValidationReportFormat
implements ValidationReportFormat {
    private static final SimpleValidationReportFormat INSTANCE = new SimpleValidationReportFormat();

    public static SimpleValidationReportFormat getInstance() {
        return INSTANCE;
    }

    @Override
    @Nonnull
    public String apply(@Nullable ValidationReport report) {
        if (report == null) {
            return "Validation report is null.";
        }
        StringBuilder b = new StringBuilder();
        if (!report.hasErrors()) {
            b.append("No validation errors.");
        } else {
            b.append("Validation failed.");
        }
        report.getMessages().forEach(m -> b.append('\n').append(SimpleValidationReportFormat.formatMessage(m)));
        return b.toString();
    }

    private static String formatMessage(ValidationReport.Message msg) {
        StringBuilder b = new StringBuilder();
        b.append("[").append((Object)msg.getLevel()).append("]").append(SimpleValidationReportFormat.formatContext(msg.getContext().orElse(null))).append(' ').append(msg.getMessage().replace("\n", "\n\t"));
        msg.getAdditionalInfo().stream().filter(Objects::nonNull).forEach(info -> b.append("\n\t* ").append(info.replace("\n", "\n\t\t")));
        msg.getNestedMessages().stream().forEach(message -> b.append(StringUtils.indentString("\n- " + SimpleValidationReportFormat.formatMessage(message), "\t")));
        return b.toString();
    }

    private static String formatContext(@Nullable ValidationReport.MessageContext ctx) {
        if (ctx == null) {
            return "";
        }
        String ctxString = Arrays.stream(new String[]{ctx.getRequestMethod().map(Enum::name).orElse(null), ctx.getRequestPath().orElse(null), ctx.getParameter().map(p -> "@" + p.getIn() + "." + p.getName()).orElse(ctx.getApiRequestBodyDefinition().map(b -> "@body").orElse(null))}).filter(Objects::nonNull).collect(Collectors.joining(" ", "[", "]"));
        return ctx.getLocation().map(l -> "[" + l.name() + "]").orElse("") + ctxString;
    }

    private SimpleValidationReportFormat() {
    }
}

