/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.oai.validator.model;

import com.atlassian.oai.validator.model.Body;
import com.atlassian.oai.validator.model.StringBody;
import com.atlassian.oai.validator.util.ContentTypeUtils;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Optional;
import javax.annotation.Nonnull;

public interface Response {
    public int getStatus();

    @Nonnull
    @Deprecated
    public Optional<String> getBody();

    @Nonnull
    default public Optional<Body> getResponseBody() {
        return this.getBody().map(content -> {
            String contentType = this.getContentType().orElse(null);
            Charset charset = ContentTypeUtils.getCharsetFromContentType(contentType).orElse(StandardCharsets.UTF_8);
            return new StringBody((String)content, charset);
        });
    }

    @Nonnull
    public Collection<String> getHeaderValues(String var1);

    @Nonnull
    default public Optional<String> getHeaderValue(String name) {
        return this.getHeaderValues(name).stream().findFirst();
    }

    @Nonnull
    default public Optional<String> getContentType() {
        return this.getHeaderValue("Content-Type");
    }
}

