/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.health.shell;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.apache.karaf.shell.api.console.CommandLine;
import org.apache.karaf.shell.api.console.Completer;
import org.apache.karaf.shell.api.console.Session;
import org.apache.karaf.shell.support.completers.StringsCompleter;
import org.opennms.core.health.api.HealthCheck;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;

@Service
public class HealthCheckTagCompleter
implements Completer {
    @Reference
    private BundleContext bundleContext;

    public int complete(Session session, CommandLine commandLine, List<String> candidates) {
        try {
            Set tags = this.bundleContext.getServiceReferences(HealthCheck.class, null).stream().flatMap(s -> ((HealthCheck)this.bundleContext.getService(s)).getTags().stream()).collect(Collectors.toSet());
            StringsCompleter delegate = new StringsCompleter();
            delegate.getStrings().addAll(tags);
            return delegate.complete(session, commandLine, candidates);
        }
        catch (InvalidSyntaxException e) {
            throw new RuntimeException("could not retrieve tags", e);
        }
    }
}

