/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.hibernate;

import java.net.InetAddress;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.Session;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.dao.api.PathOutageDao;
import org.opennms.netmgt.dao.hibernate.AbstractDaoHibernate;
import org.opennms.netmgt.model.OnmsPathOutage;
import org.springframework.orm.hibernate3.HibernateCallback;

public class PathOutageDaoHibernate
extends AbstractDaoHibernate<OnmsPathOutage, Integer>
implements PathOutageDao {
    public PathOutageDaoHibernate() {
        super(OnmsPathOutage.class);
    }

    @Override
    public List<Integer> getNodesForPathOutage(OnmsPathOutage pathOutage) {
        return this.getNodesForPathOutage(pathOutage.getCriticalPathIp(), pathOutage.getCriticalPathServiceName());
    }

    @Override
    public List<String[]> getAllCriticalPaths() {
        return (List)this.getHibernateTemplate().execute((HibernateCallback)new HibernateCallback<List<String[]>>(){

            public List<String[]> doInHibernate(Session session) throws HibernateException, SQLException {
                Query query = session.createQuery("select distinct node.label, pathOutage.criticalPathIp, pathOutage.criticalPathServiceName from OnmsPathOutage as pathOutage, OnmsIpInterface as ipInterface join ipInterface.node as node join ipInterface.monitoredServices as monitoredServices join monitoredServices.serviceType as serviceType where pathOutage.criticalPathIp = ipInterface.ipAddress and ipInterface.isManaged <> 'D' and pathOutage.criticalPathServiceName = serviceType.name and monitoredServices.status = 'A' order by node.label, pathOutage.criticalPathIp, pathOutage.criticalPathServiceName");
                List queryResults = query.list();
                if (queryResults == null || queryResults.size() == 0) {
                    return Collections.emptyList();
                }
                ArrayList<String[]> retval = new ArrayList<String[]>(queryResults.size());
                for (Object[] row : queryResults) {
                    retval.add(new String[]{(String)row[0], InetAddressUtils.str((InetAddress)((InetAddress)row[1])), (String)row[2]});
                }
                return retval;
            }
        });
    }

    @Override
    public List<Integer> getNodesForPathOutage(final InetAddress ipAddress, final String serviceName) {
        return (List)this.getHibernateTemplate().execute((HibernateCallback)new HibernateCallback<List<Integer>>(){

            public List<Integer> doInHibernate(Session session) throws HibernateException, SQLException {
                Query query = session.createQuery("select distinct node.id, node.label from OnmsPathOutage as pathOutage, OnmsIpInterface as ipInterface join pathOutage.node as node join ipInterface.monitoredServices as monitoredServices join monitoredServices.serviceType as serviceType where pathOutage.criticalPathIp = :ipAddress and pathOutage.criticalPathServiceName = :serviceName and pathOutage.criticalPathIp = ipInterface.ipAddress and ipInterface.isManaged <> 'D' and pathOutage.criticalPathServiceName = serviceType.name and monitoredServices.status = 'A' order by node.label");
                query.setParameter("ipAddress", (Object)InetAddressUtils.str((InetAddress)ipAddress));
                query.setParameter("serviceName", (Object)serviceName);
                List queryResults = query.list();
                if (queryResults == null || queryResults.size() == 0) {
                    return Collections.emptyList();
                }
                ArrayList<Integer> retval = new ArrayList<Integer>(queryResults.size());
                for (Object[] row : queryResults) {
                    retval.add((Integer)row[0]);
                }
                return retval;
            }
        });
    }

    @Override
    public List<Integer> getAllNodesDependentOnAnyServiceOnInterface(final InetAddress ipAddress) {
        return (List)this.getHibernateTemplate().execute((HibernateCallback)new HibernateCallback<List<Integer>>(){

            public List<Integer> doInHibernate(Session session) throws HibernateException, SQLException {
                Query query = session.createQuery("select distinct node.id from OnmsPathOutage as pathOutage, OnmsIpInterface as ipInterface join pathOutage.node as node join ipInterface.monitoredServices as monitoredServices where pathOutage.criticalPathIp = :ipAddress and pathOutage.criticalPathIp = ipInterface.ipAddress and ipInterface.isManaged <> 'D' and monitoredServices.status = 'A'");
                query.setParameter("ipAddress", (Object)InetAddressUtils.str((InetAddress)ipAddress));
                List result = query.list();
                if (result == null) {
                    return Collections.emptyList();
                }
                return result;
            }
        });
    }

    @Override
    public List<Integer> getAllNodesDependentOnAnyServiceOnNode(final int nodeId) {
        return (List)this.getHibernateTemplate().execute((HibernateCallback)new HibernateCallback<List<Integer>>(){

            public List<Integer> doInHibernate(Session session) throws HibernateException, SQLException {
                Query query = session.createQuery("select distinct node.id from OnmsPathOutage as pathOutage, OnmsIpInterface as ipInterface join pathOutage.node as node join ipInterface.monitoredServices as monitoredServices where ipInterface.node.id = :nodeId and pathOutage.criticalPathIp = ipInterface.ipAddress and ipInterface.isManaged <> 'D' and monitoredServices.status = 'A'");
                query.setParameter("nodeId", (Object)nodeId);
                List result = query.list();
                if (result == null) {
                    return Collections.emptyList();
                }
                return result;
            }
        });
    }
}

