/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelExecutionException;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.FluentProducerTemplate;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.processor.ConvertBodyProcessor;
import org.apache.camel.support.ServiceSupport;
import org.apache.camel.util.ExchangeHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.ServiceHelper;

public class DefaultFluentProducerTemplate
extends ServiceSupport
implements FluentProducerTemplate {
    private final ThreadLocal<Map<String, Object>> headers = new ThreadLocal();
    private final ThreadLocal<Object> body = new ThreadLocal();
    private final CamelContext context;
    private final ClassValue<ConvertBodyProcessor> resultProcessors;
    private Optional<Consumer<ProducerTemplate>> templateCustomizer;
    private Optional<Supplier<Exchange>> exchangeSupplier;
    private Optional<Supplier<Processor>> processorSupplier;
    private Optional<Endpoint> endpoint;
    private Optional<Endpoint> defaultEndpoint;
    private int maximumCacheSize;
    private boolean eventNotifierEnabled;
    private volatile ProducerTemplate template;

    public DefaultFluentProducerTemplate(CamelContext context) {
        this.context = context;
        this.endpoint = Optional.empty();
        this.defaultEndpoint = Optional.empty();
        this.eventNotifierEnabled = true;
        this.templateCustomizer = Optional.empty();
        this.exchangeSupplier = Optional.empty();
        this.processorSupplier = Optional.empty();
        this.resultProcessors = new ClassValue<ConvertBodyProcessor>(){

            @Override
            protected ConvertBodyProcessor computeValue(Class<?> type) {
                return new ConvertBodyProcessor(type);
            }
        };
    }

    @Override
    public CamelContext getCamelContext() {
        return this.context;
    }

    @Override
    public int getCurrentCacheSize() {
        if (this.template == null) {
            return 0;
        }
        return this.template.getCurrentCacheSize();
    }

    @Override
    public void cleanUp() {
        if (this.template != null) {
            this.template.cleanUp();
        }
    }

    @Override
    public void setDefaultEndpointUri(String endpointUri) {
        this.setDefaultEndpoint(this.getCamelContext().getEndpoint(endpointUri));
    }

    @Override
    public Endpoint getDefaultEndpoint() {
        return this.defaultEndpoint.orElse(null);
    }

    @Override
    public void setDefaultEndpoint(Endpoint defaultEndpoint) {
        this.defaultEndpoint = Optional.ofNullable(defaultEndpoint);
    }

    @Override
    public int getMaximumCacheSize() {
        return this.maximumCacheSize;
    }

    @Override
    public void setMaximumCacheSize(int maximumCacheSize) {
        this.maximumCacheSize = maximumCacheSize;
    }

    @Override
    public boolean isEventNotifierEnabled() {
        return this.eventNotifierEnabled;
    }

    @Override
    public void setEventNotifierEnabled(boolean eventNotifierEnabled) {
        this.eventNotifierEnabled = eventNotifierEnabled;
    }

    @Override
    public FluentProducerTemplate clearAll() {
        this.clearBody();
        this.clearHeaders();
        return this;
    }

    @Override
    public FluentProducerTemplate withHeader(String key, Object value) {
        Map<String, Object> map = this.headers.get();
        if (map == null) {
            map = new HashMap<String, Object>();
            this.headers.set(map);
        }
        map.put(key, value);
        return this;
    }

    @Override
    public FluentProducerTemplate clearHeaders() {
        this.headers.remove();
        return this;
    }

    @Override
    public FluentProducerTemplate withBody(Object body) {
        this.body.set(body);
        return this;
    }

    @Override
    public FluentProducerTemplate withBodyAs(Object body, Class<?> type) {
        Object b = type != null ? this.context.getTypeConverter().convertTo(type, body) : body;
        this.body.set(b);
        return this;
    }

    @Override
    public FluentProducerTemplate clearBody() {
        this.body.remove();
        return this;
    }

    @Override
    public FluentProducerTemplate withTemplateCustomizer(Consumer<ProducerTemplate> templateCustomizer) {
        this.templateCustomizer = Optional.of(templateCustomizer);
        return this;
    }

    @Override
    public FluentProducerTemplate withExchange(Exchange exchange) {
        return this.withExchange(() -> exchange);
    }

    @Override
    public FluentProducerTemplate withExchange(Supplier<Exchange> exchangeSupplier) {
        this.exchangeSupplier = Optional.of(exchangeSupplier);
        return this;
    }

    @Override
    public FluentProducerTemplate withProcessor(Processor processor) {
        return this.withProcessor(() -> processor);
    }

    @Override
    public FluentProducerTemplate withProcessor(Supplier<Processor> processorSupplier) {
        this.processorSupplier = Optional.of(processorSupplier);
        return this;
    }

    @Override
    public FluentProducerTemplate to(String endpointUri) {
        return this.to(this.context.getEndpoint(endpointUri));
    }

    @Override
    public FluentProducerTemplate to(Endpoint endpoint) {
        this.endpoint = Optional.of(endpoint);
        return this;
    }

    @Override
    public Object request() throws CamelExecutionException {
        return this.request(Object.class);
    }

    @Override
    public <T> T request(Class<T> type) throws CamelExecutionException {
        Object result;
        Endpoint target = this.target();
        Supplier<Processor> processorSupplier = this.processorSupplier.orElse(() -> this.defaultProcessor());
        if (type == Exchange.class) {
            result = this.template().request(target, processorSupplier.get());
        } else if (type == Message.class) {
            Exchange exchange = this.template().request(target, processorSupplier.get());
            result = exchange.hasOut() ? exchange.getOut() : exchange.getIn();
        } else {
            Exchange exchange = this.template().send(target, ExchangePattern.InOut, processorSupplier.get(), this.resultProcessors.get(type));
            result = this.context.getTypeConverter().convertTo(type, ExchangeHelper.extractResultBody(exchange, exchange.getPattern()));
        }
        return (T)result;
    }

    @Override
    public Future<Object> asyncRequest() {
        return this.asyncRequest(Object.class);
    }

    @Override
    public <T> Future<T> asyncRequest(Class<T> type) {
        CompletableFuture<T> result;
        Endpoint target = this.target();
        if (ObjectHelper.isNotEmpty(this.headers.get())) {
            HashMap<String, Object> headersCopy = new HashMap<String, Object>(this.headers.get());
            Object bodyCopy = this.body.get();
            result = this.template().asyncRequestBodyAndHeaders(target, bodyCopy, headersCopy, type);
        } else {
            Object bodyCopy = this.body.get();
            result = this.template().asyncRequestBody(target, bodyCopy, type);
        }
        return result;
    }

    @Override
    public Exchange send() throws CamelExecutionException {
        Endpoint target = this.target();
        return this.exchangeSupplier.isPresent() ? this.template().send(target, this.exchangeSupplier.get().get()) : this.template().send(target, this.processorSupplier.orElse(() -> this.defaultProcessor()).get());
    }

    @Override
    public Future<Exchange> asyncSend() {
        Endpoint target = this.target();
        return this.exchangeSupplier.isPresent() ? this.template().asyncSend(target, this.exchangeSupplier.get().get()) : this.template().asyncSend(target, this.processorSupplier.orElse(() -> this.defaultAsyncProcessor()).get());
    }

    public static FluentProducerTemplate on(CamelContext context) {
        return new DefaultFluentProducerTemplate(context);
    }

    private ProducerTemplate template() {
        ObjectHelper.notNull(this.context, "CamelContext");
        if (this.template == null) {
            this.template = this.maximumCacheSize > 0 ? this.context.createProducerTemplate(this.maximumCacheSize) : this.context.createProducerTemplate();
            this.defaultEndpoint.ifPresent(this.template::setDefaultEndpoint);
            this.template.setEventNotifierEnabled(this.eventNotifierEnabled);
            this.templateCustomizer.ifPresent(tc -> tc.accept(this.template));
        }
        return this.template;
    }

    private Processor defaultProcessor() {
        return exchange -> {
            ObjectHelper.ifNotEmpty(this.headers.get(), exchange.getIn().getHeaders()::putAll);
            ObjectHelper.ifNotEmpty(this.body.get(), exchange.getIn()::setBody);
        };
    }

    private Processor defaultAsyncProcessor() {
        HashMap<String, Object> headersCopy = ObjectHelper.isNotEmpty(this.headers.get()) ? new HashMap<String, Object>(this.headers.get()) : null;
        Object bodyCopy = this.body.get();
        return exchange -> {
            ObjectHelper.ifNotEmpty(headersCopy, exchange.getIn().getHeaders()::putAll);
            ObjectHelper.ifNotEmpty(bodyCopy, exchange.getIn()::setBody);
        };
    }

    private Endpoint target() {
        if (this.endpoint.isPresent()) {
            return this.endpoint.get();
        }
        if (this.defaultEndpoint.isPresent()) {
            return this.defaultEndpoint.get();
        }
        throw new IllegalArgumentException("No endpoint configured on FluentProducerTemplate. You can configure an endpoint with to(uri)");
    }

    @Override
    protected void doStart() throws Exception {
        if (this.template == null) {
            this.template = this.template();
        }
        ServiceHelper.startService(this.template);
    }

    @Override
    protected void doStop() throws Exception {
        this.clearAll();
        ServiceHelper.stopService(this.template);
    }
}

