/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.topology.plugins.topo.linkd.internal;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import com.google.common.collect.Lists;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.opennms.features.topology.api.browsers.ContentType;
import org.opennms.features.topology.api.browsers.SelectionAware;
import org.opennms.features.topology.api.browsers.SelectionChangedListener;
import org.opennms.features.topology.api.topo.BackendGraph;
import org.opennms.features.topology.api.topo.Criteria;
import org.opennms.features.topology.api.topo.Defaults;
import org.opennms.features.topology.api.topo.Edge;
import org.opennms.features.topology.api.topo.GraphProvider;
import org.opennms.features.topology.api.topo.Vertex;
import org.opennms.features.topology.api.topo.VertexRef;
import org.opennms.features.topology.plugins.topo.linkd.internal.LinkdEdge;
import org.opennms.features.topology.plugins.topo.linkd.internal.LinkdHopCriteria;
import org.opennms.features.topology.plugins.topo.linkd.internal.LinkdPort;
import org.opennms.features.topology.plugins.topo.linkd.internal.LinkdSelectionAware;
import org.opennms.features.topology.plugins.topo.linkd.internal.LinkdTopologyProvider;
import org.opennms.features.topology.plugins.topo.linkd.internal.LinkdVertex;
import org.opennms.netmgt.enlinkd.service.api.ProtocolSupported;
import org.opennms.netmgt.topologies.service.api.OnmsTopology;
import org.opennms.netmgt.topologies.service.api.OnmsTopologyDao;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LinkdTopologyFactory {
    private static final Logger LOG = LoggerFactory.getLogger(LinkdTopologyFactory.class);
    private LinkdTopologyProvider m_delegate;
    private final OnmsTopologyDao m_onmsTopologyDao;
    private final Timer m_loadFullTimer;
    private final SelectionAware selectionAwareDelegate;

    protected static Set<ProtocolSupported> getProtocolSupportedSet(String ... names) {
        LinkedHashSet<ProtocolSupported> protocolSupportedSet = new LinkedHashSet<ProtocolSupported>();
        for (String protocol : names) {
            if (protocol.equalsIgnoreCase(ProtocolSupported.NODES.name())) {
                protocolSupportedSet.add(ProtocolSupported.NODES);
            }
            if (protocol.equalsIgnoreCase(ProtocolSupported.CDP.name())) {
                protocolSupportedSet.add(ProtocolSupported.CDP);
            }
            if (protocol.equalsIgnoreCase(ProtocolSupported.NETWORKROUTER.name())) {
                protocolSupportedSet.add(ProtocolSupported.NETWORKROUTER);
            }
            if (protocol.equalsIgnoreCase(ProtocolSupported.LLDP.name())) {
                protocolSupportedSet.add(ProtocolSupported.LLDP);
            }
            if (protocol.equalsIgnoreCase(ProtocolSupported.BRIDGE.name())) {
                protocolSupportedSet.add(ProtocolSupported.BRIDGE);
            }
            if (protocol.equalsIgnoreCase(ProtocolSupported.OSPF.name())) {
                protocolSupportedSet.add(ProtocolSupported.OSPF);
            }
            if (protocol.equalsIgnoreCase(ProtocolSupported.OSPFAREA.name())) {
                protocolSupportedSet.add(ProtocolSupported.OSPFAREA);
            }
            if (protocol.equalsIgnoreCase(ProtocolSupported.ISIS.name())) {
                protocolSupportedSet.add(ProtocolSupported.ISIS);
            }
            if (!protocol.equalsIgnoreCase(ProtocolSupported.USERDEFINED.name())) continue;
            protocolSupportedSet.add(ProtocolSupported.USERDEFINED);
        }
        return protocolSupportedSet;
    }

    public LinkdTopologyFactory(MetricRegistry registry, OnmsTopologyDao onmsTopologyDao) {
        Objects.requireNonNull(registry);
        Objects.requireNonNull(onmsTopologyDao);
        this.m_onmsTopologyDao = onmsTopologyDao;
        this.selectionAwareDelegate = new LinkdSelectionAware(this);
        this.m_loadFullTimer = registry.timer(MetricRegistry.name((String)"enlinkd", (String[])new String[]{"load", "full"}));
    }

    public SelectionChangedListener.Selection getSelection(List<VertexRef> selectedVertices, ContentType type) {
        return this.selectionAwareDelegate.getSelection(selectedVertices, type);
    }

    public boolean contributesTo(ContentType type) {
        return this.selectionAwareDelegate.contributesTo(type);
    }

    private void loadTopology(ProtocolSupported protocol, BackendGraph graph) {
        OnmsTopology topology;
        try {
            topology = this.m_onmsTopologyDao.getTopology(protocol.name());
        }
        catch (IllegalArgumentException e) {
            LOG.info("loadTopology: protocol not supported: {}", (Object)protocol);
            return;
        }
        HashMap vmap = new HashMap();
        topology.getVertices().forEach(tvertex -> {
            LinkdVertex vertex = (LinkdVertex)graph.getVertex(this.getActiveNamespace(), tvertex.getId());
            if (vertex == null) {
                vertex = LinkdVertex.create(tvertex, this.getActiveNamespace());
                graph.addVertices(new Vertex[]{vertex});
            }
            vertex.getProtocolSupported().add(protocol);
            vmap.put(vertex.getId(), vertex);
        });
        topology.getEdges().forEach(tedge -> graph.addEdges(new Edge[]{LinkdEdge.create(tedge.getId(), LinkdPort.create(tedge.getSource(), (LinkdVertex)((Object)((Object)vmap.get(tedge.getSource().getVertex().getId())))), LinkdPort.create(tedge.getTarget(), (LinkdVertex)((Object)((Object)vmap.get(tedge.getTarget().getVertex().getId())))), protocol, this.getActiveNamespace())}));
    }

    protected Vertex getDefaultVertex(BackendGraph graph) {
        for (ProtocolSupported protocol : this.m_delegate.getProtocolSupported()) {
            OnmsTopology topology;
            try {
                topology = this.m_onmsTopologyDao.getTopology(protocol.name());
            }
            catch (Exception e) {
                LOG.error("getDefaultVertex: {}: {}: no topology found {}", new Object[]{graph.getNamespace(), protocol, e.getMessage()});
                continue;
            }
            if (topology.getDefaultVertex() == null) {
                LOG.info("getDefaultVertex: {}: {}: no default vertex found!", (Object)graph.getNamespace(), (Object)protocol);
                continue;
            }
            LOG.info("getDefaultVertex: {}, default node found: [{}]:{}", new Object[]{graph.getNamespace(), topology.getDefaultVertex().getId(), topology.getDefaultVertex().getLabel()});
            return graph.getVertex(graph.getNamespace(), topology.getDefaultVertex().getId());
        }
        LOG.info("getDefaultVertex: {}: no default vertex found", (Object)graph.getNamespace());
        return null;
    }

    protected Defaults getDefaults(BackendGraph graph) {
        return new Defaults().withSemanticZoomLevel(1).withPreferredLayout("D3 Layout").withCriteria(() -> {
            Vertex defaultVertex = this.getDefaultVertex(graph);
            if (defaultVertex != null) {
                LOG.info("getDefaults: default vertex found: [{}]:{}", (Object)defaultVertex.getId(), (Object)defaultVertex.getLabel());
                return Lists.newArrayList((Object[])new Criteria[]{LinkdHopCriteria.createCriteria(defaultVertex.getId(), defaultVertex.getLabel(), this)});
            }
            LOG.info("getDefaults: default vertex not found");
            return Lists.newArrayList();
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doRefresh(Set<ProtocolSupported> supportedProtocols, BackendGraph graph) {
        Timer.Context context = this.m_loadFullTimer.time();
        try {
            for (ProtocolSupported protocol : supportedProtocols) {
                this.loadTopology(protocol, graph);
            }
        }
        finally {
            context.stop();
        }
    }

    public GraphProvider getDelegate() {
        return this.m_delegate;
    }

    public void setDelegate(LinkdTopologyProvider delegate) {
        this.m_delegate = delegate;
    }

    public String getActiveNamespace() {
        return this.m_delegate.getNamespace();
    }
}

