/*
 * Decompiled with CFR 0.152.
 */
package org.asteriskjava.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class ReflectionUtil {
    private ReflectionUtil() {
    }

    public static Map<String, Method> getGetters(Class<?> clazz) {
        Method[] methods;
        HashMap<String, Method> accessors = new HashMap<String, Method>();
        for (Method method : methods = clazz.getMethods()) {
            String name = null;
            String methodName = method.getName();
            if (methodName.startsWith("get")) {
                name = methodName.substring(3);
            } else if (methodName.startsWith("is")) {
                name = methodName.substring(2);
            }
            if (name == null || name.length() == 0 || method.getParameterTypes().length != 0) continue;
            accessors.put(name.toLowerCase(Locale.ENGLISH), method);
        }
        return accessors;
    }

    public static Map<String, Method> getSetters(Class<?> clazz) {
        Method[] methods;
        HashMap<String, Method> accessors = new HashMap<String, Method>();
        for (Method method : methods = clazz.getMethods()) {
            String methodName = method.getName();
            if (!methodName.startsWith("set") || method.getParameterTypes().length != 1) continue;
            String name = methodName.substring("set".length()).toLowerCase(Locale.US);
            accessors.put(name, method);
        }
        return accessors;
    }

    public static String stripIllegalCharacters(String s) {
        char c;
        int i;
        boolean needsStrip = false;
        if (s == null) {
            return null;
        }
        for (i = 0; i < s.length(); ++i) {
            c = s.charAt(i);
            if (c >= '0' && c <= '9' || c >= 'a' && c <= 'z') continue;
            needsStrip = true;
            break;
        }
        if (!needsStrip) {
            return s;
        }
        StringBuffer sb = new StringBuffer(s.length());
        for (i = 0; i < s.length(); ++i) {
            c = s.charAt(i);
            if (c >= '0' && c <= '9') {
                sb.append(c);
                continue;
            }
            if (c < 'a' || c > 'z') continue;
            sb.append(c);
        }
        return sb.toString();
    }

    public static boolean isClassAvailable(String s) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        try {
            classLoader.loadClass(s);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public static Object newInstance(String s) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        try {
            Class<?> clazz = classLoader.loadClass(s);
            Constructor<?> constructor = clazz.getConstructor(new Class[0]);
            return constructor.newInstance(new Object[0]);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
        catch (IllegalAccessException e) {
            return null;
        }
        catch (InstantiationException e) {
            return null;
        }
        catch (NoSuchMethodException e) {
            return null;
        }
        catch (InvocationTargetException e) {
            return null;
        }
    }
}

