/*
 * Decompiled with CFR 0.152.
 */
package org.asteriskjava.live.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.asteriskjava.live.ManagerCommunicationException;
import org.asteriskjava.live.MeetMeRoom;
import org.asteriskjava.live.internal.AsteriskChannelImpl;
import org.asteriskjava.live.internal.AsteriskServerImpl;
import org.asteriskjava.live.internal.ChannelManager;
import org.asteriskjava.live.internal.MeetMeRoomImpl;
import org.asteriskjava.live.internal.MeetMeUserImpl;
import org.asteriskjava.manager.action.CommandAction;
import org.asteriskjava.manager.event.AbstractMeetMeEvent;
import org.asteriskjava.manager.event.MeetMeLeaveEvent;
import org.asteriskjava.manager.event.MeetMeMuteEvent;
import org.asteriskjava.manager.event.MeetMeTalkingEvent;
import org.asteriskjava.manager.response.CommandResponse;
import org.asteriskjava.manager.response.ManagerError;
import org.asteriskjava.manager.response.ManagerResponse;
import org.asteriskjava.util.DateUtil;
import org.asteriskjava.util.Log;
import org.asteriskjava.util.LogFactory;

class MeetMeManager {
    private static final String MEETME_LIST_COMMAND = "meetme list";
    private static final Pattern MEETME_LIST_PATTERN = Pattern.compile("^User #: ([0-9]+).*Channel: (\\S+).*$");
    private final Log logger = LogFactory.getLog(this.getClass());
    private final AsteriskServerImpl server;
    private final ChannelManager channelManager;
    private final Map<String, MeetMeRoomImpl> rooms;

    MeetMeManager(AsteriskServerImpl server, ChannelManager channelManager) {
        this.server = server;
        this.channelManager = channelManager;
        this.rooms = new HashMap<String, MeetMeRoomImpl>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void initialize() {
        Map<String, MeetMeRoomImpl> map = this.rooms;
        synchronized (map) {
            for (MeetMeRoomImpl room : this.rooms.values()) {
                this.populateRoom(room);
            }
        }
    }

    void disconnected() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Collection<MeetMeRoom> getMeetMeRooms() {
        ArrayList<MeetMeRoom> result = new ArrayList<MeetMeRoom>();
        Map<String, MeetMeRoomImpl> map = this.rooms;
        synchronized (map) {
            for (MeetMeRoom meetMeRoom : this.rooms.values()) {
                if (meetMeRoom.isEmpty()) continue;
                result.add(meetMeRoom);
            }
        }
        return result;
    }

    void handleMeetMeEvent(AbstractMeetMeEvent event) {
        Boolean status;
        String roomNumber = event.getMeetMe();
        if (roomNumber == null) {
            this.logger.warn("RoomNumber (meetMe property) is null. Ignoring " + event.getClass().getName());
            return;
        }
        Integer userNumber = event.getUserNum();
        if (userNumber == null) {
            this.logger.warn("UserNumber (userNum property) is null. Ignoring " + event.getClass().getName());
            return;
        }
        MeetMeUserImpl user = this.getOrCreateUserImpl(event);
        if (user == null) {
            return;
        }
        AsteriskChannelImpl channel = user.getChannel();
        MeetMeRoomImpl room = user.getRoom();
        if (event instanceof MeetMeLeaveEvent) {
            this.logger.info("Removing channel " + channel.getName() + " from room " + roomNumber);
            if (room != user.getRoom()) {
                if (user.getRoom() != null) {
                    this.logger.error("Channel " + channel.getName() + " should be removed from room " + roomNumber + " but is user of room " + user.getRoom().getRoomNumber());
                    user.getRoom().removeUser(user);
                } else {
                    this.logger.error("Channel " + channel.getName() + " should be removed from room " + roomNumber + " but is user of no room");
                }
            }
            user.left(event.getDateReceived());
            room.removeUser(user);
            channel.setMeetMeUserImpl(null);
        } else if (event instanceof MeetMeTalkingEvent) {
            Boolean status2 = ((MeetMeTalkingEvent)event).getStatus();
            if (status2 != null) {
                user.setTalking(status2);
            } else {
                user.setTalking(true);
            }
        } else if (event instanceof MeetMeMuteEvent && (status = ((MeetMeMuteEvent)event).getStatus()) != null) {
            user.setMuted(status);
        }
    }

    private void populateRoom(MeetMeRoomImpl room) {
        ManagerResponse response;
        ArrayList<Integer> userNumbers = new ArrayList<Integer>();
        CommandAction meetMeListAction = new CommandAction("meetme list " + room.getRoomNumber());
        try {
            response = this.server.sendAction(meetMeListAction);
        }
        catch (ManagerCommunicationException e) {
            this.logger.error("Unable to send \"meetme list\" command", e);
            return;
        }
        if (response instanceof ManagerError) {
            this.logger.error("Unable to send \"meetme list\" command: " + response.getMessage());
            return;
        }
        if (!(response instanceof CommandResponse)) {
            this.logger.error("Response to \"meetme list\" command is not a CommandResponse but " + response.getClass());
            return;
        }
        List<String> lines = ((CommandResponse)response).getResult();
        for (String line : lines) {
            MeetMeUserImpl roomUser;
            MeetMeUserImpl channelUser;
            boolean muted = false;
            boolean talking = false;
            Matcher matcher = MEETME_LIST_PATTERN.matcher(line);
            if (!matcher.matches()) continue;
            Integer userNumber = Integer.valueOf(matcher.group(1));
            AsteriskChannelImpl channel = this.channelManager.getChannelImplByName(matcher.group(2));
            userNumbers.add(userNumber);
            if (line.contains("(Admin Muted)") || line.contains("(Muted)")) {
                muted = true;
            }
            if (line.contains("(talking)")) {
                talking = true;
            }
            if ((channelUser = channel.getMeetMeUser()) != null && channelUser.getRoom() != room) {
                channelUser.left(DateUtil.getDate());
                channelUser = null;
            }
            if ((roomUser = room.getUser(userNumber)) != null && roomUser.getChannel() != channel) {
                room.removeUser(roomUser);
                roomUser = null;
            }
            if (channelUser == null && roomUser == null) {
                MeetMeUserImpl user = new MeetMeUserImpl(this.server, room, userNumber, channel, DateUtil.getDate());
                user.setMuted(muted);
                user.setTalking(talking);
                room.addUser(user);
                channel.setMeetMeUserImpl(user);
                this.server.fireNewMeetMeUser(user);
                continue;
            }
            if (channelUser != null && roomUser == null) {
                channelUser.setMuted(muted);
                room.addUser(channelUser);
                continue;
            }
            if (channelUser == null) {
                roomUser.setMuted(muted);
                channel.setMeetMeUserImpl(roomUser);
                continue;
            }
            if (channelUser == roomUser) continue;
            this.logger.error("Inconsistent state: channelUser != roomUser, channelUser=" + channelUser + ", roomUser=" + roomUser);
        }
        Collection<MeetMeUserImpl> users = room.getUserImpls();
        ArrayList<MeetMeUserImpl> usersToRemove = new ArrayList<MeetMeUserImpl>();
        for (MeetMeUserImpl user : users) {
            if (userNumbers.contains(user.getUserNumber())) continue;
            usersToRemove.add(user);
        }
        for (MeetMeUserImpl user : usersToRemove) {
            user.left(DateUtil.getDate());
            room.removeUser(user);
            user.getChannel().setMeetMeUserImpl(null);
        }
    }

    private MeetMeUserImpl getOrCreateUserImpl(AbstractMeetMeEvent event) {
        String roomNumber = event.getMeetMe();
        MeetMeRoomImpl room = this.getOrCreateRoomImpl(roomNumber);
        MeetMeUserImpl user = room.getUser(event.getUserNum());
        if (user != null) {
            return user;
        }
        String uniqueId = event.getUniqueId();
        if (uniqueId == null) {
            this.logger.warn("UniqueId is null. Ignoring MeetMeEvent");
            return null;
        }
        AsteriskChannelImpl channel = this.channelManager.getChannelImplById(uniqueId);
        if (channel == null) {
            this.logger.warn("No channel with unique id " + uniqueId + ". Ignoring MeetMeEvent");
            return null;
        }
        user = channel.getMeetMeUser();
        if (user != null) {
            this.logger.error("Got MeetMeEvent for channel " + channel.getName() + " that is already user of a room");
            user.left(event.getDateReceived());
            if (user.getRoom() != null) {
                user.getRoom().removeUser(user);
            }
            channel.setMeetMeUserImpl(null);
        }
        this.logger.info("Adding channel " + channel.getName() + " as user " + event.getUserNum() + " to room " + roomNumber);
        user = new MeetMeUserImpl(this.server, room, event.getUserNum(), channel, event.getDateReceived());
        room.addUser(user);
        channel.setMeetMeUserImpl(user);
        this.server.fireNewMeetMeUser(user);
        return user;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    MeetMeRoomImpl getOrCreateRoomImpl(String roomNumber) {
        MeetMeRoomImpl room;
        boolean created = false;
        Map<String, MeetMeRoomImpl> map = this.rooms;
        synchronized (map) {
            room = this.rooms.get(roomNumber);
            if (room == null) {
                room = new MeetMeRoomImpl(this.server, roomNumber);
                this.populateRoom(room);
                this.rooms.put(roomNumber, room);
                created = true;
            }
        }
        if (created) {
            this.logger.debug("Created MeetMeRoom " + roomNumber);
        }
        return room;
    }
}

