/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.graph.provider.topology;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.opennms.features.topology.api.browsers.ContentType;
import org.opennms.features.topology.api.browsers.SelectionChangedListener;
import org.opennms.features.topology.api.topo.AbstractVertex;
import org.opennms.features.topology.api.topo.BackendGraph;
import org.opennms.features.topology.api.topo.Defaults;
import org.opennms.features.topology.api.topo.GraphProvider;
import org.opennms.features.topology.api.topo.TopologyProviderInfo;
import org.opennms.features.topology.api.topo.VertexRef;
import org.opennms.netmgt.dao.api.NodeDao;
import org.opennms.netmgt.graph.api.enrichment.EnrichmentService;
import org.opennms.netmgt.graph.api.generic.GenericGraph;
import org.opennms.netmgt.graph.api.service.GraphService;
import org.opennms.netmgt.graph.provider.topology.LegacyBackendGraph;
import org.opennms.netmgt.graph.provider.topology.LegacyTopologyConfiguration;
import org.opennms.netmgt.graph.provider.topology.LegacyTopologyProviderInfo;

public class LegacyTopologyProvider
implements GraphProvider {
    private final String containerId;
    private final String namespace;
    private final GraphService graphService;
    private final NodeDao nodeDao;
    private final boolean resolveNodeIds;
    private final EnrichmentService enrichmentService;
    private LegacyBackendGraph backendGraph;

    public LegacyTopologyProvider(LegacyTopologyConfiguration configuration, NodeDao nodeDao, GraphService graphService, EnrichmentService enrichmentService, String containerId, String graphNamespace) {
        this.containerId = Objects.requireNonNull(containerId);
        this.namespace = Objects.requireNonNull(graphNamespace);
        this.graphService = Objects.requireNonNull(graphService);
        this.enrichmentService = Objects.requireNonNull(enrichmentService);
        this.nodeDao = Objects.requireNonNull(nodeDao);
        this.resolveNodeIds = Objects.requireNonNull(configuration).isResolveNodeIds();
    }

    public BackendGraph getCurrentGraph() {
        return this.backendGraph;
    }

    public void refresh() {
        GenericGraph graph = this.graphService.getGraph(this.containerId, this.namespace);
        if (this.resolveNodeIds) {
            graph = this.enrichmentService.enrich(graph);
        }
        this.backendGraph = new LegacyBackendGraph(graph);
    }

    public String getNamespace() {
        return this.namespace;
    }

    public Defaults getDefaults() {
        return new Defaults().withPreferredLayout("D3 Layout").withSemanticZoomLevel(1).withCriteria(() -> {
            if (this.backendGraph != null) {
                return this.backendGraph.getDefaultCriteria();
            }
            return Lists.newArrayList();
        });
    }

    public TopologyProviderInfo getTopologyProviderInfo() {
        return new LegacyTopologyProviderInfo(this.graphService.getGraphInfo(this.namespace));
    }

    public SelectionChangedListener.Selection getSelection(List<VertexRef> selectedVertices, ContentType type) {
        Set nodeIds = selectedVertices.stream().filter(v -> this.namespace.equals(v.getNamespace())).filter(v -> v instanceof AbstractVertex).map(v -> (AbstractVertex)v).map(v -> v.getNodeID()).filter(nodeId -> nodeId != null).collect(Collectors.toSet());
        if (type == ContentType.Alarm) {
            return new SelectionChangedListener.AlarmNodeIdSelection(nodeIds);
        }
        if (type == ContentType.Node) {
            return new SelectionChangedListener.IdSelection(nodeIds);
        }
        return SelectionChangedListener.Selection.NONE;
    }

    public boolean contributesTo(ContentType type) {
        return Sets.newHashSet((Object[])new ContentType[]{ContentType.Alarm, ContentType.Node}).contains(type);
    }
}

