/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.telemetry.protocols.netflow.parser.ie.values;

import com.google.common.base.MoreObjects;
import io.netty.buffer.ByteBuf;
import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import org.opennms.netmgt.telemetry.listeners.utils.BufferUtils;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.ie.InformationElement;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.ie.Semantics;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.ie.Value;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.session.Session;

public class DateTimeValue
extends Value<Instant> {
    public static final long SECONDS_TO_EPOCH = 2208988800L;
    private final Instant value;

    public DateTimeValue(String name, Optional<Semantics> semantics, Instant value) {
        super(name, semantics);
        this.value = Objects.requireNonNull(value);
    }

    public DateTimeValue(String name, Instant value) {
        this(name, Optional.empty(), value);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.getName()).add("value", (Object)this.value).toString();
    }

    public static InformationElement parserWithSeconds(final String name, final Optional<Semantics> semantics) {
        return new InformationElement(){

            @Override
            public Value<?> parse(Session.Resolver resolver, ByteBuf buffer) {
                return new DateTimeValue(name, semantics, Instant.ofEpochSecond(BufferUtils.uint32((ByteBuf)buffer)));
            }

            @Override
            public String getName() {
                return name;
            }

            @Override
            public int getMinimumFieldLength() {
                return 4;
            }

            @Override
            public int getMaximumFieldLength() {
                return 4;
            }
        };
    }

    public static InformationElement parserWithMilliseconds(final String name, final Optional<Semantics> semantics) {
        return new InformationElement(){

            @Override
            public Value<?> parse(Session.Resolver resolver, ByteBuf buffer) {
                return new DateTimeValue(name, semantics, Instant.ofEpochMilli(BufferUtils.uint64((ByteBuf)buffer).longValue()));
            }

            @Override
            public String getName() {
                return name;
            }

            @Override
            public int getMinimumFieldLength() {
                return 8;
            }

            @Override
            public int getMaximumFieldLength() {
                return 8;
            }
        };
    }

    public static InformationElement parserWithMicroseconds(final String name, final Optional<Semantics> semantics) {
        return new InformationElement(){

            @Override
            public Value<?> parse(Session.Resolver resolver, ByteBuf buffer) {
                long seconds = BufferUtils.uint32((ByteBuf)buffer);
                long fraction = BufferUtils.uint32((ByteBuf)buffer) & 0xFFFFFFFFFFFFF800L;
                Instant value = Instant.ofEpochSecond(seconds - 2208988800L, fraction * 1000000000L / 0x100000000L);
                return new DateTimeValue(name, semantics, value);
            }

            @Override
            public String getName() {
                return name;
            }

            @Override
            public int getMinimumFieldLength() {
                return 8;
            }

            @Override
            public int getMaximumFieldLength() {
                return 8;
            }
        };
    }

    public static InformationElement parserWithNanoseconds(final String name, final Optional<Semantics> semantics) {
        return new InformationElement(){

            @Override
            public Value<?> parse(Session.Resolver resolver, ByteBuf buffer) {
                long seconds = BufferUtils.uint32((ByteBuf)buffer);
                long fraction = BufferUtils.uint32((ByteBuf)buffer);
                Instant value = Instant.ofEpochSecond(seconds - 2208988800L, fraction * 1000000000L / 0x100000000L);
                return new DateTimeValue(name, semantics, value);
            }

            @Override
            public String getName() {
                return name;
            }

            @Override
            public int getMinimumFieldLength() {
                return 8;
            }

            @Override
            public int getMaximumFieldLength() {
                return 8;
            }
        };
    }

    @Override
    public Instant getValue() {
        return this.value;
    }

    @Override
    public void visit(Value.Visitor visitor) {
        visitor.accept(this);
    }
}

