/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.telemetry.shell;

import com.google.common.base.Throwables;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.time.Duration;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.PropertyAccessorFactory;

public class Utils {
    public static final Gson GSON = new GsonBuilder().setPrettyPrinting().registerTypeAdapter(Duration.class, (Object)new DurationTypeAdapter()).create();

    public static JsonObject getWritableProperties(Object bean) {
        BeanWrapper wrapper = PropertyAccessorFactory.forBeanPropertyAccess((Object)bean);
        JsonObject result = new JsonObject();
        for (PropertyDescriptor desc : wrapper.getPropertyDescriptors()) {
            if (desc.getReadMethod() == null || desc.getWriteMethod() == null) continue;
            try {
                result.add(desc.getDisplayName(), GSON.toJsonTree(desc.getReadMethod().invoke(bean, new Object[0])));
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw Throwables.propagate((Throwable)e);
            }
        }
        return result;
    }

    public static class DurationTypeAdapter
    extends TypeAdapter<Duration> {
        public void write(JsonWriter out, Duration value) throws IOException {
            out.value(value.getSeconds());
        }

        public Duration read(JsonReader in) throws IOException {
            return Duration.ofSeconds(in.nextLong());
        }
    }
}

