/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.upgrade.implementations;

import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.opennms.core.utils.ConfigFileConstants;
import org.opennms.core.utils.DBUtils;
import org.opennms.netmgt.config.KSC_PerformanceReportFactory;
import org.opennms.netmgt.config.kscReports.Graph;
import org.opennms.netmgt.config.kscReports.Report;
import org.opennms.netmgt.vmmgr.ControllerUtils;
import org.opennms.upgrade.api.AbstractOnmsUpgrade;
import org.opennms.upgrade.api.OnmsUpgradeException;
import org.opennms.upgrade.implementations.SnmpInterface;

public class KscReportsMigrator
extends AbstractOnmsUpgrade {
    private File configFile;

    public KscReportsMigrator() throws OnmsUpgradeException {
        try {
            this.configFile = ConfigFileConstants.getFile((int)ConfigFileConstants.KSC_REPORT_FILE_NAME);
        }
        catch (IOException e) {
            throw new OnmsUpgradeException("Can't find KSC Configuration file", e);
        }
    }

    @Override
    public int getOrder() {
        return 6;
    }

    @Override
    public String getDescription() {
        return "Fixes the KSC Reports because of SNMP Interface directories changes";
    }

    @Override
    public boolean requiresOnmsRunning() {
        return this.isOpennmsRunning();
    }

    @Override
    public void preExecute() throws OnmsUpgradeException {
        try {
            this.log("Backing up %s\n", this.configFile);
            this.zipFile(this.configFile);
            this.initializeDatasource();
            KSC_PerformanceReportFactory.init();
        }
        catch (Exception e) {
            throw new OnmsUpgradeException("Can't initialize ksc-performance-reports.xml because " + e.getMessage());
        }
    }

    @Override
    public void postExecute() throws OnmsUpgradeException {
        File zip = new File(this.configFile.getAbsolutePath() + ".zip");
        if (zip.exists()) {
            this.log("Removing backup %s\n", zip);
            FileUtils.deleteQuietly((File)zip);
        }
    }

    @Override
    public void rollback() throws OnmsUpgradeException {
        this.log("Restoring backup %s\n", this.configFile);
        File zip = new File(this.configFile.getAbsolutePath() + ".zip");
        FileUtils.deleteQuietly((File)this.configFile);
        this.unzipFile(zip, zip.getParentFile());
    }

    @Override
    public void execute() throws OnmsUpgradeException {
        this.log("Fixing KSC Reports.\n", new Object[0]);
        boolean changed = false;
        List<SnmpInterface> interfacesToMerge = this.getInterfacesToMerge();
        for (Integer reportId : KSC_PerformanceReportFactory.getInstance().getReportList().keySet()) {
            Report report = KSC_PerformanceReportFactory.getInstance().getReportByIndex(reportId.intValue());
            this.log("  Checking report %s\n", report.getTitle());
            for (Graph graph : report.getGraphs()) {
                for (SnmpInterface intf : interfacesToMerge) {
                    String resourceId;
                    if (!intf.shouldUpdate(resourceId = (String)graph.getResourceId().orElse(null))) continue;
                    changed = true;
                    this.log("  replacing resource ID %s with %s for %s\n", graph.getResourceId(), intf.getNewResourceId(), graph.getTitle());
                    graph.setResourceId(intf.getNewResourceId().toString());
                }
            }
        }
        if (changed) {
            this.log("Updating the KSC reports configuration file.\n", new Object[0]);
            try {
                KSC_PerformanceReportFactory.getInstance().saveCurrent();
            }
            catch (Exception e) {
                this.log("Warning: can't save KSC Reports because %s\n", e.getMessage());
            }
            if (this.isOpennmsRunning()) {
                this.log("In case the OpenNMS WebUI can't see the changes, go to Reports -> KSC Performance, Nodes, Domains and click on 'Request a Reload of KSC Reports Configuration'\n", new Object[0]);
            }
        } else {
            this.log("No incomplete interface names detected.\n", new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<SnmpInterface> getInterfacesToMerge() throws OnmsUpgradeException {
        ArrayList<SnmpInterface> interfacesToMerge = new ArrayList<SnmpInterface>();
        Connection conn = this.getDbConnection();
        DBUtils db = new DBUtils(this.getClass());
        db.watch((Object)conn);
        try {
            Statement st = conn.createStatement();
            db.watch((Object)st);
            String query = "SELECT n.nodeid, n.foreignsource, n.foreignid, i.snmpifdescr, i.snmpifname, i.snmpphysaddr from node n, snmpinterface i where n.nodeid = i.nodeid and i.snmpphysaddr is not null order by n.nodeid, i.snmpifdescr";
            ResultSet rs = st.executeQuery(query);
            db.watch((Object)rs);
            while (rs.next()) {
                interfacesToMerge.add(new SnmpInterface(rs, this.isStoreByForeignSourceEnabled()));
            }
        }
        catch (Throwable t) {
            this.log("Error: can't retrieve the required data from the OpenNMS Database or there were problems while processing them.\n", new Object[0]);
            String reason = t.getMessage();
            if (reason == null) {
                reason = "Unknown";
            }
            this.log("Reason(%s): %s\n", t.getClass().getName(), reason);
            t.printStackTrace();
        }
        finally {
            db.cleanUp();
        }
        return interfacesToMerge;
    }

    protected boolean isOpennmsRunning() {
        try {
            return ControllerUtils.getController().status() == 0;
        }
        catch (Exception e) {
            this.log("Warning: can't retrieve OpeNNMS status (assuming it is not running).\n", new Object[0]);
            return false;
        }
    }
}

