/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.upgrade.implementations;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.LineIterator;
import org.jrobin.core.RrdDb;
import org.opennms.core.utils.AlphaNumeric;
import org.opennms.core.utils.ConfigFileConstants;
import org.opennms.netmgt.config.CollectdConfigFactory;
import org.opennms.netmgt.config.JMXDataCollectionConfigDao;
import org.opennms.netmgt.config.collectd.CollectdConfiguration;
import org.opennms.netmgt.config.collectd.Collector;
import org.opennms.netmgt.config.collectd.Package;
import org.opennms.netmgt.config.collectd.Parameter;
import org.opennms.netmgt.config.collectd.Service;
import org.opennms.upgrade.api.AbstractOnmsUpgrade;
import org.opennms.upgrade.api.OnmsUpgradeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JmxRrdMigratorOffline
extends AbstractOnmsUpgrade {
    private static final Logger LOG = LoggerFactory.getLogger(JmxRrdMigratorOffline.class);
    private final JMXDataCollectionConfigDao jmxDataCollectionConfigDao = new JMXDataCollectionConfigDao();
    private List<File> jmxResourceDirectories;
    protected List<String> badMetrics = new ArrayList<String>();
    protected List<File> backupFiles = new ArrayList<File>();

    @Override
    public int getOrder() {
        return 4;
    }

    @Override
    public String getDescription() {
        return "Fix the JRB names for the new JMX Collector: NMS-1539, NMS-3485, NMS-4592, NMS-4612, NMS-5247, NMS-5279, NMS-5824";
    }

    @Override
    public boolean requiresOnmsRunning() {
        return false;
    }

    @Override
    public void preExecute() throws OnmsUpgradeException {
        this.printMainSettings();
        if (this.isInstalledVersionGreaterOrEqual(1, 12, 2)) {
            try {
                this.jmxDataCollectionConfigDao.getConfig();
            }
            catch (Exception e) {
                throw new OnmsUpgradeException("Can't initialize jmx-datacollection-config.xml because " + e.getMessage());
            }
            for (File jmxResourceDir : this.getJmxResourceDirectories()) {
                this.log("Backing up %s\n", jmxResourceDir);
                this.zipDir(new File(jmxResourceDir.getAbsolutePath() + ".zip"), jmxResourceDir);
            }
        } else {
            throw new OnmsUpgradeException("This upgrade procedure requires at least OpenNMS 1.12.2; the current version is " + this.getOpennmsVersion());
        }
    }

    @Override
    public void postExecute() throws OnmsUpgradeException {
        for (File jmxResourceDir : this.getJmxResourceDirectories()) {
            File zip = new File(jmxResourceDir.getAbsolutePath() + ".zip");
            if (!zip.exists()) continue;
            this.log("Removing backup %s\n", zip);
            FileUtils.deleteQuietly((File)zip);
        }
        for (File backupFile : this.backupFiles) {
            this.log("Removing backup %s\n", backupFile);
            FileUtils.deleteQuietly((File)backupFile);
            FileUtils.deleteQuietly((File)new File(backupFile.getAbsolutePath().replaceFirst(".zip", ".temp")));
        }
    }

    @Override
    public void rollback() throws OnmsUpgradeException {
        try {
            for (File jmxResourceDir : this.getJmxResourceDirectories()) {
                File zip = new File(jmxResourceDir.getAbsolutePath() + ".zip");
                FileUtils.deleteDirectory((File)jmxResourceDir);
                if (!jmxResourceDir.mkdirs()) {
                    LOG.warn("Could not make directory: {}", (Object)jmxResourceDir.getPath());
                }
                this.unzipFile(zip, jmxResourceDir);
                if (zip.delete()) continue;
                LOG.warn("Could not delete file: {}", (Object)zip.getPath());
            }
            File configDir = new File(ConfigFileConstants.getFilePathString());
            for (File backupFile : this.backupFiles) {
                this.unzipFile(backupFile, configDir);
            }
        }
        catch (IOException e) {
            throw new OnmsUpgradeException("Can't restore the backup files because " + e.getMessage());
        }
    }

    @Override
    public void execute() throws OnmsUpgradeException {
        try {
            boolean isRrdtool = this.isRrdToolEnabled();
            boolean storeByGroup = this.isStoreByGroupEnabled();
            for (File jmxResourceDir : this.getJmxResourceDirectories()) {
                if (storeByGroup) {
                    this.processGroupFiles(jmxResourceDir, isRrdtool);
                    continue;
                }
                this.processSingleFiles(jmxResourceDir, isRrdtool);
            }
            File jmxConfigFile = null;
            try {
                jmxConfigFile = ConfigFileConstants.getFile((int)ConfigFileConstants.JMX_DATA_COLLECTION_CONF_FILE_NAME);
            }
            catch (IOException e) {
                throw new OnmsUpgradeException("Can't find JMX Configuration file (ignoring processing)");
            }
            this.fixJmxConfigurationFile(jmxConfigFile);
            this.log("Found %s Bad Metrics: %s\n", this.badMetrics.size(), this.badMetrics);
            File jmxGraphsFile = new File(ConfigFileConstants.getFilePathString(), "snmp-graph.properties");
            this.fixJmxGraphTemplateFile(jmxGraphsFile);
        }
        catch (Exception e) {
            throw new OnmsUpgradeException("Can't upgrade the JRBs because " + e.getMessage(), e);
        }
    }

    private void fixJmxConfigurationFile(File jmxConfigFile) throws OnmsUpgradeException {
        try {
            this.log("Updating JMX metric definitions on %s\n", jmxConfigFile);
            this.zipFile(jmxConfigFile);
            this.backupFiles.add(new File(jmxConfigFile.getAbsolutePath() + ".zip"));
            File outputFile = new File(jmxConfigFile.getCanonicalFile() + ".temp");
            FileWriter w = new FileWriter(outputFile);
            Pattern extRegex = Pattern.compile("import-mbeans[>](.+)[<]");
            Pattern aliasRegex = Pattern.compile("alias=\"([^\"]+\\.[^\"]+)\"");
            ArrayList<File> externalFiles = new ArrayList<File>();
            LineIterator it = FileUtils.lineIterator((File)jmxConfigFile);
            while (it.hasNext()) {
                String line = it.next();
                Matcher m = extRegex.matcher(line);
                if (m.find()) {
                    externalFiles.add(new File(jmxConfigFile.getParentFile(), m.group(1)));
                }
                if ((m = aliasRegex.matcher(line)).find()) {
                    String badDs = m.group(1);
                    String fixedDs = this.getFixedDsName(badDs);
                    this.log("  Replacing bad alias %s with %s on %s\n", badDs, fixedDs, line.trim());
                    line = line.replaceAll(badDs, fixedDs);
                    if (!this.badMetrics.contains(badDs)) {
                        this.badMetrics.add(badDs);
                    }
                }
                w.write(line + "\n");
            }
            LineIterator.closeQuietly((LineIterator)it);
            w.close();
            FileUtils.deleteQuietly((File)jmxConfigFile);
            FileUtils.moveFile((File)outputFile, (File)jmxConfigFile);
            if (!externalFiles.isEmpty()) {
                for (File configFile : externalFiles) {
                    this.fixJmxConfigurationFile(configFile);
                }
            }
        }
        catch (Exception e) {
            throw new OnmsUpgradeException("Can't fix " + jmxConfigFile + " because " + e.getMessage(), e);
        }
    }

    private void fixJmxGraphTemplateFile(File jmxTemplateFile) throws OnmsUpgradeException {
        try {
            this.log("Updating JMX graph templates on %s\n", jmxTemplateFile);
            this.zipFile(jmxTemplateFile);
            this.backupFiles.add(new File(jmxTemplateFile.getAbsolutePath() + ".zip"));
            File outputFile = new File(jmxTemplateFile.getCanonicalFile() + ".temp");
            FileWriter w = new FileWriter(outputFile);
            Pattern defRegex = Pattern.compile("DEF:.+:(.+\\..+):");
            Pattern colRegex = Pattern.compile("\\.columns=(.+)$");
            Pattern incRegex = Pattern.compile("^include.directory=(.+)$");
            ArrayList<File> externalFiles = new ArrayList<File>();
            boolean override = false;
            LineIterator it = FileUtils.lineIterator((File)jmxTemplateFile);
            while (it.hasNext()) {
                File includeDirectory;
                String line = it.next();
                Matcher m = incRegex.matcher(line);
                if (m.find() && (includeDirectory = new File(jmxTemplateFile.getParentFile(), m.group(1))).isDirectory()) {
                    FilenameFilter filenameFilter = new FilenameFilter(){

                        @Override
                        public boolean accept(File dir, String name) {
                            return name.endsWith(".properties");
                        }
                    };
                    File[] fileArray = includeDirectory.listFiles(filenameFilter);
                    int n = fileArray.length;
                    for (int i = 0; i < n; ++i) {
                        File file = fileArray[i];
                        externalFiles.add(file);
                    }
                }
                if ((m = colRegex.matcher(line)).find()) {
                    String[] badColumns;
                    for (String badDs : badColumns = m.group(1).split(",(\\s)?")) {
                        String fixedDs = this.getFixedDsName(badDs);
                        if (fixedDs.equals(badDs)) continue;
                        if (this.badMetrics.contains(badDs)) {
                            override = true;
                            this.log("  Replacing bad data source %s with %s on %s\n", badDs, fixedDs, line);
                            line = line.replaceAll(badDs, fixedDs);
                            continue;
                        }
                        this.log("  Warning: a bad data source not related with JMX has been found: %s (this won't be updated)\n", badDs);
                    }
                }
                if ((m = defRegex.matcher(line)).find()) {
                    String badDs = m.group(1);
                    if (this.badMetrics.contains(badDs)) {
                        override = true;
                        String string = this.getFixedDsName(badDs);
                        this.log("  Replacing bad data source %s with %s on %s\n", badDs, string, line);
                        line = line.replaceAll(badDs, string);
                    } else {
                        this.log("  Warning: a bad data source not related with JMX has been found: %s (this won't be updated)\n", badDs);
                    }
                }
                w.write(line + "\n");
            }
            LineIterator.closeQuietly((LineIterator)it);
            w.close();
            if (override) {
                FileUtils.deleteQuietly((File)jmxTemplateFile);
                FileUtils.moveFile((File)outputFile, (File)jmxTemplateFile);
            } else {
                FileUtils.deleteQuietly((File)outputFile);
            }
            if (!externalFiles.isEmpty()) {
                for (File configFile : externalFiles) {
                    this.fixJmxGraphTemplateFile(configFile);
                }
            }
        }
        catch (Exception e) {
            throw new OnmsUpgradeException("Can't fix " + jmxTemplateFile + " because " + e.getMessage(), e);
        }
    }

    private List<File> getJmxResourceDirectories() throws OnmsUpgradeException {
        if (this.jmxResourceDirectories == null) {
            CollectdConfiguration config;
            this.jmxResourceDirectories = new ArrayList<File>();
            try {
                config = new CollectdConfigFactory().getLocalCollectdConfig();
            }
            catch (Exception e) {
                throw new OnmsUpgradeException("Can't upgrade the JRBs because " + e.getMessage(), e);
            }
            List<String> services = this.getJmxServices(config);
            this.log("JMX services found: %s\n", services);
            ArrayList<String> jmxFriendlyNames = new ArrayList<String>();
            for (String service : services) {
                Service svc = this.getServiceObject(config, service);
                if (svc != null) {
                    String friendlyName = this.getSvcPropertyValue(svc, "friendly-name");
                    if (friendlyName == null) {
                        friendlyName = this.getSvcPropertyValue(svc, "port");
                    }
                    if (friendlyName == null) {
                        this.log("Warning: there is no friendly-name or port parameter for service %s. The JRBs/RRDs for this service are not going to be updated.", service);
                        continue;
                    }
                    jmxFriendlyNames.add(friendlyName);
                    continue;
                }
                this.log("Warning: JMX service %s is defined but not used in any package definition. Skipping migration.\n", service);
            }
            this.log("JMX friendly names found: %s\n", jmxFriendlyNames);
            File rrdDir = new File(this.jmxDataCollectionConfigDao.getRrdPath());
            this.findJmxDirectories(rrdDir, jmxFriendlyNames, this.jmxResourceDirectories);
            if (this.jmxResourceDirectories.isEmpty()) {
                this.log("Warning: no JMX directories found on %s\n", rrdDir);
            }
        }
        return this.jmxResourceDirectories;
    }

    private void findJmxDirectories(File rrdDir, List<String> jmxfriendlyNames, List<File> jmxDirectories) {
        File[] files = rrdDir.listFiles();
        if (files == null) {
            return;
        }
        for (File file : files) {
            if (!file.isDirectory()) continue;
            boolean valid = false;
            for (String friendlyName : jmxfriendlyNames) {
                if (!file.getAbsolutePath().endsWith(friendlyName)) continue;
                valid = true;
            }
            if (valid) {
                jmxDirectories.add(file);
            }
            this.findJmxDirectories(file, jmxfriendlyNames, jmxDirectories);
        }
    }

    private void processSingleFiles(File resourceDir, boolean isRrdtool) throws Exception {
        String metaExt = ".meta";
        File[] metaFiles = this.getFiles(resourceDir, ".meta");
        if (metaFiles == null) {
            this.log("Warning: there are no %s files on %s\n", ".meta", resourceDir);
        } else {
            for (File metaFile : metaFiles) {
                this.log("Processing META %s\n", metaFile);
                String dsName = metaFile.getName().replaceFirst(".meta", "");
                String newName = this.getFixedDsName(dsName);
                if (dsName.equals(newName)) continue;
                Properties meta = new Properties();
                Properties newMeta = new Properties();
                try (FileReader fr = new FileReader(metaFile);){
                    meta.load(fr);
                    for (Object k : meta.keySet()) {
                        String key = (String)k;
                        String newKey = key.replaceAll(dsName, newName);
                        newMeta.put(newKey, newName);
                    }
                    File newFile = new File(metaFile.getParentFile(), newName + ".meta");
                    this.log("Re-creating META into %s\n", newFile);
                    try (FileWriter fw = new FileWriter(newFile);){
                        newMeta.store(fw, null);
                    }
                    if (metaFile.equals(newFile) || metaFile.delete()) continue;
                    LOG.warn("Could not delete file {}", (Object)metaFile.getPath());
                }
            }
        }
        String rrdExt = this.getRrdExtension();
        File[] jrbFiles = this.getFiles(resourceDir, rrdExt);
        if (jrbFiles == null) {
            this.log("Warning: there are no %s files on %s\n", rrdExt, resourceDir);
        } else {
            for (File jrbFile : jrbFiles) {
                this.log("Processing %s %s\n", rrdExt.toUpperCase(), jrbFile);
                String dsName = jrbFile.getName().replaceFirst(rrdExt, "");
                String newName = this.getFixedDsName(dsName);
                File newFile = new File(jrbFile.getParentFile(), newName + rrdExt);
                if (!dsName.equals(newName)) {
                    try {
                        this.log("Renaming %s to %s\n", rrdExt.toUpperCase(), newFile);
                        FileUtils.moveFile((File)jrbFile, (File)newFile);
                    }
                    catch (Exception e) {
                        this.log("Warning: Can't move file because: %s", e.getMessage());
                        continue;
                    }
                }
                if (isRrdtool) continue;
                this.updateJrb(newFile);
            }
        }
    }

    private void processGroupFiles(File resourceDir, boolean isRrdtool) throws Exception {
        Object newFile;
        File dsFile = new File(resourceDir, "ds.properties");
        this.log("Processing DS %s\n", dsFile);
        if (dsFile.exists()) {
            Properties dsProperties = new Properties();
            Properties newDsProperties = new Properties();
            try (FileReader fr = new FileReader(dsFile);){
                dsProperties.load(fr);
                for (Object key : dsProperties.keySet()) {
                    String oldName = (String)key;
                    String newName = this.getFixedDsName(oldName);
                    String oldFile = dsProperties.getProperty(oldName);
                    newFile = this.getFixedFileName(oldFile);
                    newDsProperties.put(newName, newFile);
                }
                try (FileWriter fw = new FileWriter(dsFile);){
                    newDsProperties.store(new FileWriter(dsFile), null);
                }
            }
        }
        String metaExt = ".meta";
        File[] metaFiles = this.getFiles(resourceDir, ".meta");
        if (metaFiles == null) {
            this.log("Warning: there are no %s files on %s\n", ".meta", resourceDir);
        } else {
            for (File metaFile : metaFiles) {
                this.log("Processing META %s\n", metaFile);
                Properties meta = new Properties();
                Properties newMeta = new Properties();
                try (FileReader fr = new FileReader(metaFile);){
                    meta.load(fr);
                    for (Object k : meta.keySet()) {
                        String key = (String)k;
                        String dsName = meta.getProperty(key);
                        String newName = this.getFixedDsName(dsName);
                        String newKey = key.replaceAll(dsName, newName);
                        newMeta.put(newKey, newName);
                    }
                    File newFile2 = new File(metaFile.getParentFile(), this.getFixedFileName(metaFile.getName().replaceFirst(".meta", "")) + ".meta");
                    this.log("Recreating META into %s\n", newFile2);
                    try (FileWriter fw = new FileWriter(newFile2);){
                        newMeta.store(fw, null);
                    }
                    if (metaFile.equals(newFile2) || metaFile.delete()) continue;
                    LOG.warn("Could not delete file: {}", (Object)metaFile.getPath());
                }
            }
        }
        String rrdExt = this.getRrdExtension();
        File[] jrbFiles = this.getFiles(resourceDir, rrdExt);
        if (jrbFiles == null) {
            this.log("Warning: there are no %s files on %s\n", rrdExt, resourceDir);
        } else {
            for (File jrbFile : jrbFiles) {
                this.log("Processing %s %s\n", rrdExt.toUpperCase(), jrbFile);
                newFile = new File(jrbFile.getParentFile(), this.getFixedFileName(jrbFile.getName().replaceFirst(rrdExt, "")) + rrdExt);
                if (!jrbFile.equals(newFile)) {
                    try {
                        this.log("Renaming %s to %s\n", rrdExt.toUpperCase(), newFile);
                        FileUtils.moveFile((File)jrbFile, (File)newFile);
                    }
                    catch (Exception e) {
                        this.log("Warning: Can't move file because: %s", e.getMessage());
                        continue;
                    }
                }
                if (isRrdtool) continue;
                this.updateJrb((File)newFile);
            }
        }
    }

    private void updateJrb(File jrbFile) throws Exception {
        RrdDb rrdDb = new RrdDb(jrbFile);
        for (String ds : rrdDb.getDsNames()) {
            String newDs = this.getFixedDsName(ds);
            if (ds.equals(newDs)) continue;
            this.log("Updating internal DS name from %s to %s\n", ds, newDs);
            rrdDb.getDatasource(ds).setDsName(newDs);
        }
        rrdDb.close();
    }

    private List<String> getJmxServices(CollectdConfiguration config) {
        ArrayList<String> services = new ArrayList<String>();
        for (Collector c : config.getCollectors()) {
            if (!c.getClassName().matches(".*(JBoss|JMXSecure|Jsr160|MX4J)Collector$")) continue;
            services.add(c.getService());
        }
        return services;
    }

    private Service getServiceObject(CollectdConfiguration config, String service) {
        for (Package pkg : config.getPackages()) {
            for (Service svc : pkg.getServices()) {
                if (!svc.getName().equals(service)) continue;
                return svc;
            }
        }
        return null;
    }

    private String getSvcPropertyValue(Service svc, String propertyName) {
        if (svc.getParameters() == null) {
            return null;
        }
        for (Parameter p : svc.getParameters()) {
            if (!p.getKey().equals(propertyName)) continue;
            return p.getValue();
        }
        return null;
    }

    protected String getFixedDsName(String dsName) {
        if (dsName.contains(".")) {
            String[] parts = dsName.split("\\.");
            return parts[0] + parts[1].substring(0, 1).toUpperCase() + parts[1].substring(1);
        }
        return dsName;
    }

    protected String getFixedFileName(String oldFile) {
        return AlphaNumeric.parseAndReplace((String)oldFile, (char)'_');
    }
}

