/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.xml.eventconf;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.opennms.core.utils.RegexUtils;
import org.opennms.netmgt.events.api.EventConstants;
import org.opennms.netmgt.xml.event.Event;
import org.opennms.netmgt.xml.event.Parm;
import org.opennms.netmgt.xml.event.Value;
import org.opennms.netmgt.xml.eventconf.EventMatcher;
import org.opennms.netmgt.xml.eventconf.Field;
import org.opennms.netmgt.xml.eventconf.MatchResult;

public abstract class EventMatchers {
    public static EventMatcher falseMatcher() {
        return new EventMatcher(){

            @Override
            public MatchResult matches(Event matchingEvent) {
                return MatchResult.FALSE;
            }

            public String toString() {
                return "false";
            }
        };
    }

    public static EventMatcher trueMatcher() {
        return new EventMatcher(){

            @Override
            public MatchResult matches(Event matchingEvent) {
                return MatchResult.TRUE;
            }

            public String toString() {
                return "true";
            }
        };
    }

    public static EventMatcher ueiMatcher(final String uei) {
        return new EventMatcher(){

            @Override
            public MatchResult matches(Event matchingEvent) {
                String matchingUei = matchingEvent.getUei();
                return MatchResult.of(uei.equals(matchingUei));
            }

            public String toString() {
                return "event.uei==" + uei;
            }
        };
    }

    public static EventMatcher and(final EventMatcher ... matchers) {
        return new EventMatcher(){

            @Override
            public MatchResult matches(Event matchingEvent) {
                MatchResult match = MatchResult.TRUE;
                for (EventMatcher matcher : matchers) {
                    if ((match = match.and(matcher.matches(matchingEvent))).matched()) continue;
                    return match;
                }
                return match;
            }

            public String toString() {
                StringBuilder buf = new StringBuilder();
                boolean first = true;
                for (EventMatcher matcher : matchers) {
                    if (first) {
                        first = false;
                    } else {
                        buf.append("&&");
                    }
                    buf.append("(").append(matcher).append(")");
                }
                return buf.toString();
            }
        };
    }

    public static EventMatcher or(final EventMatcher ... matchers) {
        return new EventMatcher(){

            @Override
            public MatchResult matches(Event matchingEvent) {
                for (EventMatcher matcher : matchers) {
                    MatchResult match = matcher.matches(matchingEvent);
                    if (!match.matched()) continue;
                    return match;
                }
                return MatchResult.FALSE;
            }

            public String toString() {
                StringBuilder buf = new StringBuilder();
                boolean first = true;
                for (EventMatcher matcher : matchers) {
                    if (first) {
                        first = false;
                    } else {
                        buf.append("||");
                    }
                    buf.append("(").append(matcher).append(")");
                }
                return buf.toString();
            }
        };
    }

    public static Field varbind(final int vbnumber) {
        if (vbnumber <= 0) {
            throw new IllegalArgumentException("Invalid varbind index " + vbnumber + " must be 1 or greater.");
        }
        return new Field(){

            @Override
            public String get(Event event) {
                List parms = event.getParmCollection();
                return vbnumber > parms.size() ? null : EventConstants.getValueAsString((Value)((Parm)parms.get(vbnumber - 1)).getValue());
            }

            public String toString() {
                return "event.varbind#" + vbnumber;
            }
        };
    }

    public static Field field(String name) {
        if (name.startsWith("parm[") && name.endsWith("]")) {
            final String parmName = name.substring(5, name.length() - 1);
            return new EventField(name){

                @Override
                public String get(Event event) {
                    if (event != null && event.getParm(parmName) != null && event.getParm(parmName).getValue() != null) {
                        return event.getParm(parmName).getValue().getContent();
                    }
                    return null;
                }
            };
        }
        if (name.equals("uei")) {
            return new EventField(name){

                @Override
                public String get(Event event) {
                    return event.getUei();
                }
            };
        }
        if (name.equals("source")) {
            return new EventField(name){

                @Override
                public String get(Event event) {
                    return event.getSource();
                }
            };
        }
        if (name.equals("nodeid")) {
            return new EventField(name){

                @Override
                public String get(Event event) {
                    return Long.toString(event.getNodeid());
                }
            };
        }
        if (name.equals("host")) {
            return new EventField(name){

                @Override
                public String get(Event event) {
                    return event.getHost();
                }
            };
        }
        if (name.equals("interface")) {
            return new EventField(name){

                @Override
                public String get(Event event) {
                    return event.getInterface();
                }
            };
        }
        if (name.equals("snmphost")) {
            return new EventField(name){

                @Override
                public String get(Event event) {
                    return event.getSnmphost();
                }
            };
        }
        if (name.equals("service")) {
            return new EventField(name){

                @Override
                public String get(Event event) {
                    return event.getService();
                }
            };
        }
        if (name.equals("id")) {
            return new EventField(name){

                @Override
                public String get(Event event) {
                    return event.getSnmp() == null ? null : event.getSnmp().getId();
                }
            };
        }
        if (name.equals("community")) {
            return new EventField(name){

                @Override
                public String get(Event event) {
                    return event.getSnmp() == null ? null : event.getSnmp().getCommunity();
                }
            };
        }
        if (name.equals("specific")) {
            return new EventField(name){

                @Override
                public String get(Event event) {
                    return event.getSnmp() == null || !event.getSnmp().hasSpecific() ? null : Integer.toString(event.getSnmp().getSpecific());
                }
            };
        }
        if (name.equals("generic")) {
            return new EventField(name){

                @Override
                public String get(Event event) {
                    return event.getSnmp() == null || !event.getSnmp().hasGeneric() ? null : Integer.toString(event.getSnmp().getGeneric());
                }
            };
        }
        if (name.equals("trapoid")) {
            return new EventField(name){

                @Override
                public String get(Event event) {
                    return event.getSnmp() == null || !event.getSnmp().hasTrapOID() ? null : event.getSnmp().getTrapOID();
                }
            };
        }
        throw new IllegalStateException("Field " + name + " is not understood!");
    }

    public static EventMatcher valueStartsWithMatcher(final Field field, final String value) {
        final String prefix = value.substring(0, value.length() - 1);
        return new EventMatcher(){

            @Override
            public MatchResult matches(Event matchingEvent) {
                String eventValue = field.get(matchingEvent);
                return MatchResult.of(eventValue != null && (eventValue.startsWith(prefix) || eventValue.equals(value)));
            }

            public String toString() {
                return field + ".startsWith(" + prefix + ")";
            }
        };
    }

    public static EventMatcher valueMatchesRegexMatcher(final Field field, final String value) {
        final Pattern eventValueRegex = Pattern.compile(value.startsWith("~") ? value.substring(1) : value);
        final Set namedCaptureGroupsFromRegex = RegexUtils.getNamedCaptureGroupsFromPattern((String)eventValueRegex.pattern());
        return new EventMatcher(){

            @Override
            public MatchResult matches(Event matchingEvent) {
                String eventValue = field.get(matchingEvent);
                if (eventValue == null) {
                    return MatchResult.FALSE;
                }
                if (eventValue.equals(value)) {
                    return MatchResult.TRUE;
                }
                Matcher eventValueMatcher = eventValueRegex.matcher(eventValue);
                if (!eventValueMatcher.matches()) {
                    return MatchResult.FALSE;
                }
                if (namedCaptureGroupsFromRegex.isEmpty()) {
                    return MatchResult.TRUE;
                }
                LinkedHashMap<String, String> extractedParms = new LinkedHashMap<String, String>(namedCaptureGroupsFromRegex.size());
                for (String namedCaptureGroup : namedCaptureGroupsFromRegex) {
                    try {
                        String groupValue = eventValueMatcher.group(namedCaptureGroup);
                        if (groupValue == null) continue;
                        extractedParms.put(namedCaptureGroup, groupValue);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {}
                }
                return MatchResult.of(true, extractedParms);
            }

            public String toString() {
                return field + "~" + eventValueRegex;
            }
        };
    }

    public static EventMatcher valueEqualsMatcher(final Field field, final String value) {
        return new EventMatcher(){

            @Override
            public MatchResult matches(Event matchingEvent) {
                String eventValue = field.get(matchingEvent);
                return MatchResult.of(eventValue != null && eventValue.equals(value));
            }

            public String toString() {
                return field + "==" + value;
            }
        };
    }

    private static abstract class EventField
    implements Field {
        private String m_name;

        public EventField(String name) {
            this.m_name = name;
        }

        public String toString() {
            return "event." + this.m_name;
        }

        @Override
        public abstract String get(Event var1);
    }
}

