/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.notifd;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.opennms.core.xml.ValidateUsing;
import org.opennms.netmgt.config.utils.ConfigUtils;

@XmlRootElement(name="auto-acknowledge-alarm")
@XmlAccessorType(value=XmlAccessType.FIELD)
@ValidateUsing(value="notifd-configuration.xsd")
public class AutoAcknowledgeAlarm
implements Serializable {
    private static final long serialVersionUID = 2L;
    private static final String DEFAULT_RESOLUTION_PREFIX = "RESOLVED: ";
    @XmlAttribute(name="resolution-prefix")
    private String m_resolutionPrefix;
    @XmlAttribute(name="notify")
    private Boolean m_notify;
    @XmlElement(name="uei")
    private List<String> m_ueis = new ArrayList<String>();

    public String getResolutionPrefix() {
        return this.m_resolutionPrefix != null ? this.m_resolutionPrefix : DEFAULT_RESOLUTION_PREFIX;
    }

    public void setResolutionPrefix(String resolutionPrefix) {
        this.m_resolutionPrefix = ConfigUtils.normalizeString(resolutionPrefix);
    }

    public Boolean getNotify() {
        return this.m_notify != null ? this.m_notify : Boolean.TRUE;
    }

    public void setNotify(Boolean notify) {
        this.m_notify = notify;
    }

    public List<String> getUeis() {
        return this.m_ueis;
    }

    public void setUei(List<String> ueis) {
        if (ueis == this.m_ueis) {
            return;
        }
        this.m_ueis.clear();
        if (ueis != null) {
            this.m_ueis.addAll(ueis);
        }
    }

    public void addUei(String uei) {
        this.m_ueis.add(uei);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof AutoAcknowledgeAlarm) {
            AutoAcknowledgeAlarm that = (AutoAcknowledgeAlarm)obj;
            return Objects.equals(this.m_resolutionPrefix, that.m_resolutionPrefix) && Objects.equals(this.m_notify, that.m_notify) && Objects.equals(this.m_ueis, that.m_ueis);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.m_resolutionPrefix, this.m_notify, this.m_ueis);
    }
}

