/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.syslog4j.impl.net.tcp;

import org.graylog2.syslog4j.SyslogConstants;
import org.graylog2.syslog4j.impl.net.AbstractNetSyslogConfig;
import org.graylog2.syslog4j.impl.net.tcp.TCPNetSyslog;
import org.graylog2.syslog4j.impl.net.tcp.TCPNetSyslogConfigIF;
import org.graylog2.syslog4j.impl.net.tcp.TCPNetSyslogWriter;
import org.graylog2.syslog4j.util.SyslogUtility;

public class TCPNetSyslogConfig
extends AbstractNetSyslogConfig
implements TCPNetSyslogConfigIF {
    private static final long serialVersionUID = 9023152050686365460L;
    public static byte[] SYSTEM_DELIMITER_SEQUENCE = null;
    protected byte[] delimiterSequence = SYSTEM_DELIMITER_SEQUENCE;
    protected boolean persistentConnection = true;
    protected boolean soLinger = true;
    protected int soLingerSeconds = 1;
    protected boolean keepAlive = true;
    protected boolean reuseAddress = true;
    protected boolean setBufferSize = true;
    protected int freshConnectionInterval = -1;
    private boolean useOctetCounting;

    public TCPNetSyslogConfig() {
        this.initialize();
    }

    protected void initialize() {
    }

    public TCPNetSyslogConfig(int facility, String host, int port) {
        super(facility, host, port);
        this.initialize();
    }

    public TCPNetSyslogConfig(int facility, String host) {
        super(facility, host);
        this.initialize();
    }

    public TCPNetSyslogConfig(int facility) {
        super(facility);
        this.initialize();
    }

    public TCPNetSyslogConfig(String host, int port) {
        super(host, port);
        this.initialize();
    }

    public TCPNetSyslogConfig(String host) {
        super(host);
        this.initialize();
    }

    @Override
    public Class getSyslogClass() {
        return TCPNetSyslog.class;
    }

    @Override
    public byte[] getDelimiterSequence() {
        return this.delimiterSequence;
    }

    @Override
    public void setDelimiterSequence(byte[] delimiterSequence) {
        this.delimiterSequence = delimiterSequence;
    }

    public void setDelimiterSequence(String delimiterSequence) {
        this.delimiterSequence = SyslogUtility.getBytes(this, delimiterSequence);
    }

    @Override
    public boolean isPersistentConnection() {
        return this.persistentConnection;
    }

    @Override
    public void setPersistentConnection(boolean persistentConnection) {
        this.persistentConnection = persistentConnection;
    }

    @Override
    public boolean isSoLinger() {
        return this.soLinger;
    }

    @Override
    public void setSoLinger(boolean soLinger) {
        this.soLinger = soLinger;
    }

    @Override
    public int getSoLingerSeconds() {
        return this.soLingerSeconds;
    }

    @Override
    public void setSoLingerSeconds(int soLingerSeconds) {
        this.soLingerSeconds = soLingerSeconds;
    }

    @Override
    public boolean isKeepAlive() {
        return this.keepAlive;
    }

    @Override
    public void setKeepAlive(boolean keepAlive) {
        this.keepAlive = keepAlive;
    }

    @Override
    public boolean isReuseAddress() {
        return this.reuseAddress;
    }

    @Override
    public void setReuseAddress(boolean reuseAddress) {
        this.reuseAddress = reuseAddress;
    }

    @Override
    public boolean isSetBufferSize() {
        return this.setBufferSize;
    }

    @Override
    public void setSetBufferSize(boolean setBufferSize) {
        this.setBufferSize = setBufferSize;
    }

    @Override
    public int getFreshConnectionInterval() {
        return this.freshConnectionInterval;
    }

    @Override
    public void setFreshConnectionInterval(int freshConnectionInterval) {
        this.freshConnectionInterval = freshConnectionInterval;
    }

    @Override
    public void setUseOctetCounting(boolean useOctetCounting) {
        this.useOctetCounting = useOctetCounting;
    }

    @Override
    public boolean isUseOctetCounting() {
        return this.useOctetCounting;
    }

    @Override
    public Class getSyslogWriterClass() {
        return TCPNetSyslogWriter.class;
    }

    static {
        String delimiterSequence = System.getProperty("line.separator");
        SYSTEM_DELIMITER_SEQUENCE = delimiterSequence.getBytes();
        if (SYSTEM_DELIMITER_SEQUENCE == null || SYSTEM_DELIMITER_SEQUENCE.length < 1) {
            SYSTEM_DELIMITER_SEQUENCE = SyslogConstants.TCP_DELIMITER_SEQUENCE_DEFAULT;
        }
    }
}

