/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.syslogd;

import java.util.Objects;
import org.opennms.core.ipc.sink.api.AsyncDispatcher;
import org.opennms.core.ipc.sink.api.MessageDispatcherFactory;
import org.opennms.core.ipc.sink.api.SinkModule;
import org.opennms.core.logging.Logging;
import org.opennms.netmgt.config.SyslogdConfig;
import org.opennms.netmgt.dao.api.DistPollerDao;
import org.opennms.netmgt.syslogd.SyslogReceiver;
import org.opennms.netmgt.syslogd.SyslogSinkModule;
import org.opennms.netmgt.syslogd.api.SyslogConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class SinkDispatchingSyslogReceiver
implements SyslogReceiver {
    private static final Logger LOG = LoggerFactory.getLogger(SinkDispatchingSyslogReceiver.class);
    @Autowired
    private DistPollerDao m_distPollerDao;
    @Autowired
    private MessageDispatcherFactory m_messageDispatcherFactory;
    private final SyslogdConfig m_config;
    protected AsyncDispatcher<SyslogConnection> m_dispatcher;

    public SinkDispatchingSyslogReceiver(SyslogdConfig config) {
        this.m_config = Objects.requireNonNull(config);
    }

    @Override
    public void run() {
        Logging.putPrefix((String)"syslogd");
        SyslogSinkModule syslogSinkModule = new SyslogSinkModule(this.m_config, this.m_distPollerDao);
        this.m_dispatcher = this.m_messageDispatcherFactory.createAsyncDispatcher((SinkModule)syslogSinkModule);
    }

    @Override
    public void stop() throws InterruptedException {
        try {
            if (this.m_dispatcher != null) {
                this.m_dispatcher.close();
                this.m_dispatcher = null;
            }
        }
        catch (Exception e) {
            LOG.warn("Exception while closing dispatcher.", (Throwable)e);
        }
    }

    public void setDistPollerDao(DistPollerDao distPollerDao) {
        this.m_distPollerDao = distPollerDao;
    }

    public void setMessageDispatcherFactory(MessageDispatcherFactory messageDispatcherFactory) {
        this.m_messageDispatcherFactory = messageDispatcherFactory;
    }
}

