/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.dataproviders;

import java.lang.reflect.Array;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class ArrayIterator
implements Iterator {
    protected Object array;
    protected int endIndex = 0;
    protected int index = 0;

    public ArrayIterator(Object array) {
        this.setArray(array);
    }

    protected void checkBound(int bound, String type) {
        if (bound > this.endIndex) {
            throw new ArrayIndexOutOfBoundsException("Attempt to make an ArrayIterator that " + type + "s beyond the end of the array. ");
        }
        if (bound < 0) {
            throw new ArrayIndexOutOfBoundsException("Attempt to make an ArrayIterator that " + type + "s before the start of the array. ");
        }
    }

    @Override
    public boolean hasNext() {
        return this.index < this.endIndex;
    }

    public Object next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return Array.get(this.array, this.index++);
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("remove() method is not supported");
    }

    public Object getArray() {
        return this.array;
    }

    private void setArray(Object array) {
        this.endIndex = Array.getLength(array);
        this.array = array;
        this.index = 0;
    }
}

