/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim25.mo;

import com.vmware.vim25.AlreadyExists;
import com.vmware.vim25.CustomizationFault;
import com.vmware.vim25.CustomizationSpecInfo;
import com.vmware.vim25.CustomizationSpecItem;
import com.vmware.vim25.ManagedObjectReference;
import com.vmware.vim25.NotFound;
import com.vmware.vim25.RuntimeFault;
import com.vmware.vim25.mo.ManagedObject;
import com.vmware.vim25.mo.ServerConnection;
import java.rmi.RemoteException;

public class CustomizationSpecManager
extends ManagedObject {
    public CustomizationSpecManager(ServerConnection sc, ManagedObjectReference mor) {
        super(sc, mor);
    }

    public byte[] getEncryptionKey() {
        return (byte[])this.getCurrentProperty("encryptionKey");
    }

    public CustomizationSpecInfo[] getInfo() {
        return (CustomizationSpecInfo[])this.getCurrentProperty("info");
    }

    public void checkCustomizationResources(String guestOs) throws CustomizationFault, RuntimeFault, RemoteException {
        this.getVimService().checkCustomizationResources(this.getMOR(), guestOs);
    }

    public void createCustomizationSpec(CustomizationSpecItem item) throws CustomizationFault, AlreadyExists, RuntimeFault, RemoteException {
        this.getVimService().createCustomizationSpec(this.getMOR(), item);
    }

    public String customizationSpecItemToXml(CustomizationSpecItem item) throws RuntimeFault, RemoteException {
        return this.getVimService().customizationSpecItemToXml(this.getMOR(), item);
    }

    public void deleteCustomizationSpec(String name) throws NotFound, RuntimeFault, RemoteException {
        this.getVimService().deleteCustomizationSpec(this.getMOR(), name);
    }

    public boolean doesCustomizationSpecExist(String name) throws RuntimeFault, RemoteException {
        return this.getVimService().doesCustomizationSpecExist(this.getMOR(), name);
    }

    public void duplicateCustomizationSpec(String name, String newName) throws AlreadyExists, NotFound, RuntimeFault, RemoteException {
        this.getVimService().duplicateCustomizationSpec(this.getMOR(), name, newName);
    }

    public CustomizationSpecItem getCustomizationSpec(String name) throws NotFound, RuntimeFault, RemoteException {
        return this.getVimService().getCustomizationSpec(this.getMOR(), name);
    }

    public void overwriteCustomizationSpec(CustomizationSpecItem item) throws NotFound, RuntimeFault, RemoteException {
        this.getVimService().overwriteCustomizationSpec(this.getMOR(), item);
    }

    public void renameCustomizationSpec(String name, String newName) throws AlreadyExists, NotFound, RuntimeFault, RemoteException {
        this.getVimService().renameCustomizationSpec(this.getMOR(), name, newName);
    }

    public CustomizationSpecItem xmlToCustomizationSpecItem(String specItemXml) throws CustomizationFault, RuntimeFault, RemoteException {
        return this.getVimService().xmlToCustomizationSpecItem(this.getMOR(), specItemXml);
    }
}

