/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.profile.assembly;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.karaf.features.internal.download.Downloader;
import org.apache.karaf.features.internal.download.StreamProvider;
import org.apache.karaf.features.internal.model.Config;
import org.apache.karaf.features.internal.model.ConfigFile;
import org.apache.karaf.features.internal.model.Content;
import org.apache.karaf.features.internal.model.Feature;
import org.apache.karaf.profile.assembly.ArtifactInstaller;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigInstaller {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigInstaller.class);
    private Path etcDirectory;
    private List<String> pidsToExtract;

    public ConfigInstaller(Path etcDirectory, List<String> pidsToExtract) {
        this.etcDirectory = etcDirectory;
        this.pidsToExtract = pidsToExtract;
    }

    public void installConfigs(Feature feature, Downloader downloader, ArtifactInstaller installer) throws Exception {
        ArrayList<Feature> contents = new ArrayList<Feature>();
        contents.add(feature);
        contents.addAll(feature.getConditional());
        for (Content content : contents) {
            for (Config config : content.getConfig()) {
                if (!config.isExternal()) continue;
                installer.installArtifact(config.getValue().trim());
            }
            for (ConfigFile configFile : content.getConfigfile()) {
                installer.installArtifact(configFile.getLocation().trim());
            }
            Path homeDirectory = this.etcDirectory.getParent();
            for (Config config : content.getConfig()) {
                if (!this.pidMatching(config.getName())) continue;
                Path configFile = this.etcDirectory.resolve(config.getName() + ".cfg");
                boolean configFileExist = Files.exists(configFile, new LinkOption[0]);
                if (!config.isAppend() && configFileExist) {
                    LOGGER.info("      not changing existing config file: {}", (Object)homeDirectory.relativize(configFile));
                    continue;
                }
                if (config.isExternal()) {
                    downloader.download(config.getValue().trim(), provider -> {
                        StreamProvider streamProvider = provider;
                        synchronized (streamProvider) {
                            if (config.isAppend()) {
                                byte[] data = Files.readAllBytes(provider.getFile().toPath());
                                LOGGER.info("      appending to config file: {}", (Object)homeDirectory.relativize(configFile));
                                Files.write(configFile, data, StandardOpenOption.APPEND);
                            } else {
                                LOGGER.info("      adding config file: {}", (Object)homeDirectory.relativize(configFile));
                                Files.copy(provider.getFile().toPath(), configFile, StandardCopyOption.REPLACE_EXISTING);
                            }
                        }
                    });
                    continue;
                }
                if (config.isAppend()) {
                    if (configFileExist) {
                        LOGGER.info("      appending to config file: {}", (Object)homeDirectory.relativize(configFile));
                        Files.write(configFile, config.getValue().getBytes(), StandardOpenOption.APPEND);
                        continue;
                    }
                    LOGGER.warn("      Could not append, because config file does not exist: {}", (Object)homeDirectory.relativize(configFile));
                    continue;
                }
                LOGGER.info("      adding config file: {}", (Object)homeDirectory.relativize(configFile));
                Files.write(configFile, config.getValue().getBytes(), new OpenOption[0]);
            }
        }
    }

    private boolean pidMatching(String name) {
        if (this.pidsToExtract == null) {
            return true;
        }
        for (String p : this.pidsToExtract) {
            String r;
            boolean negated = false;
            if (p.startsWith("!")) {
                negated = true;
                p = p.substring(1);
            }
            if (!Pattern.matches(r = this.globToRegex(p), name)) continue;
            return !negated;
        }
        return false;
    }

    private String globToRegex(String pattern) {
        StringBuilder sb = new StringBuilder(pattern.length());
        int inGroup = 0;
        int inClass = 0;
        int firstIndexInClass = -1;
        char[] arr = pattern.toCharArray();
        block16: for (int i = 0; i < arr.length; ++i) {
            char ch = arr[i];
            switch (ch) {
                case '\\': {
                    if (++i >= arr.length) {
                        sb.append('\\');
                        continue block16;
                    }
                    char next = arr[i];
                    switch (next) {
                        case ',': {
                            break;
                        }
                        case 'E': 
                        case 'Q': {
                            sb.append('\\');
                        }
                        default: {
                            sb.append('\\');
                        }
                    }
                    sb.append(next);
                    continue block16;
                }
                case '*': {
                    if (inClass == 0) {
                        sb.append(".*");
                        continue block16;
                    }
                    sb.append('*');
                    continue block16;
                }
                case '?': {
                    if (inClass == 0) {
                        sb.append('.');
                        continue block16;
                    }
                    sb.append('?');
                    continue block16;
                }
                case '[': {
                    ++inClass;
                    firstIndexInClass = i + 1;
                    sb.append('[');
                    continue block16;
                }
                case ']': {
                    --inClass;
                    sb.append(']');
                    continue block16;
                }
                case '$': 
                case '%': 
                case '(': 
                case ')': 
                case '+': 
                case '.': 
                case '@': 
                case '^': 
                case '|': {
                    if (inClass == 0 || firstIndexInClass == i && ch == '^') {
                        sb.append('\\');
                    }
                    sb.append(ch);
                    continue block16;
                }
                case '!': {
                    if (firstIndexInClass == i) {
                        sb.append('^');
                        continue block16;
                    }
                    sb.append('!');
                    continue block16;
                }
                case '{': {
                    ++inGroup;
                    sb.append('(');
                    continue block16;
                }
                case '}': {
                    --inGroup;
                    sb.append(')');
                    continue block16;
                }
                case ',': {
                    if (inGroup > 0) {
                        sb.append('|');
                        continue block16;
                    }
                    sb.append(',');
                    continue block16;
                }
                default: {
                    sb.append(ch);
                }
            }
        }
        return sb.toString();
    }
}

