/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.collectd;

import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.opennms.netmgt.collectd.MibPropertyAttributeType;
import org.opennms.netmgt.collectd.SnmpAttribute;
import org.opennms.netmgt.collectd.SnmpCollectionResource;
import org.opennms.netmgt.collectd.SnmpPropertyExtender;
import org.opennms.netmgt.collection.api.AttributeGroup;
import org.opennms.netmgt.collection.api.AttributeGroupType;
import org.opennms.netmgt.collection.api.CollectionAttribute;
import org.opennms.netmgt.config.datacollection.MibObjProperty;
import org.opennms.netmgt.snmp.SnmpUtils;
import org.opennms.netmgt.snmp.SnmpValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnumLookupPropertyExtender
implements SnmpPropertyExtender {
    private static final Logger LOG = LoggerFactory.getLogger(EnumLookupPropertyExtender.class);
    private static final String ENUM_ATTRIBUTE = "enum-attribute";
    private static final String DEFAULT_VALUE = "default-value";

    @Override
    public SnmpAttribute getTargetAttribute(List<CollectionAttribute> sourceAttributes, SnmpCollectionResource targetResource, MibObjProperty property) {
        String defaultValue = property.getParameterValue(DEFAULT_VALUE);
        String enumAttribute = property.getParameterValue(ENUM_ATTRIBUTE);
        if (StringUtils.isBlank((String)enumAttribute)) {
            LOG.warn("Cannot execute the enum-lookup property extender because: missing parameter {}", (Object)ENUM_ATTRIBUTE);
            return null;
        }
        for (AttributeGroup group : targetResource.getGroups()) {
            for (CollectionAttribute attribute : group.getAttributes()) {
                if (!enumAttribute.equals(attribute.getName())) continue;
                String result = property.getParameterValue(attribute.getStringValue(), defaultValue);
                if (result == null) {
                    return null;
                }
                AttributeGroupType groupType = targetResource.getGroupType(property.getGroupName());
                MibPropertyAttributeType type = new MibPropertyAttributeType(targetResource.getResourceType(), property, groupType);
                SnmpValue value = SnmpUtils.getValueFactory().getOctetString(result.getBytes());
                return new SnmpAttribute(targetResource, type, value);
            }
        }
        return null;
    }
}

