/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.telemetry.protocols.bmp.parser.proto.bgp.packets.pathattr;

import com.google.common.collect.Lists;
import io.netty.buffer.ByteBuf;
import java.net.UnknownHostException;
import java.util.List;
import java.util.Optional;
import org.opennms.netmgt.telemetry.listeners.utils.BufferUtils;
import org.opennms.netmgt.telemetry.protocols.bmp.parser.InvalidPacketException;
import org.opennms.netmgt.telemetry.protocols.bmp.parser.proto.bgp.packets.UpdatePacket;
import org.opennms.netmgt.telemetry.protocols.bmp.parser.proto.bgp.packets.pathattr.Attribute;
import org.opennms.netmgt.telemetry.protocols.bmp.parser.proto.bgp.packets.pathattr.MultiprotocolReachableNlri;
import org.opennms.netmgt.telemetry.protocols.bmp.parser.proto.bmp.PeerFlags;
import org.opennms.netmgt.telemetry.protocols.bmp.parser.proto.bmp.PeerInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiprotocolUnreachableNlri
implements Attribute {
    public static final Logger LOG = LoggerFactory.getLogger(MultiprotocolUnreachableNlri.class);
    public final int afi;
    public final int safi;
    public List<UpdatePacket.Prefix> withdrawn = Lists.newArrayList();
    public List<UpdatePacket.Prefix> vpnWithdrawn = Lists.newArrayList();

    public MultiprotocolUnreachableNlri(ByteBuf buffer, PeerFlags flags, Optional<PeerInfo> peerInfo) throws InvalidPacketException {
        this.afi = BufferUtils.uint16((ByteBuf)buffer);
        this.safi = BufferUtils.uint8((ByteBuf)buffer);
        try {
            this.parseAfi(buffer, peerInfo);
        }
        catch (UnknownHostException ex) {
            throw new InvalidPacketException(buffer, "Error parsing IP address", ex);
        }
        catch (Exception ex) {
            throw new InvalidPacketException(buffer, "Error parsing packet", ex);
        }
    }

    void parseAfi(ByteBuf buffer, Optional<PeerInfo> peerInfo) throws Exception {
        switch (this.afi) {
            case 2: {
                this.parseAfi_IPv4IPv6(false, buffer, peerInfo);
                break;
            }
            case 1: {
                this.parseAfi_IPv4IPv6(true, buffer, peerInfo);
                break;
            }
            case 16388: {
                LOG.info("MP_UNREACH AFI=bgp-ls SAFI={} is not implemented yet, skipping for now", (Object)this.safi);
                break;
            }
            case 25: {
                LOG.info("EVPN AFI=bgp_afi_l2vpn SAFI={} is not implemented yet, skipping", (Object)this.safi);
                break;
            }
            default: {
                LOG.info("MP_UNREACH AFI={} is not implemented yet, skipping", (Object)this.afi);
            }
        }
    }

    void parseAfi_IPv4IPv6(boolean isIPv4, ByteBuf buffer, Optional<PeerInfo> peerInfo) throws Exception {
        switch (this.safi) {
            case 1: {
                this.withdrawn = MultiprotocolReachableNlri.parseNlriData_IPv4IPv6(isIPv4, buffer, peerInfo);
                break;
            }
            case 4: {
                this.withdrawn = MultiprotocolReachableNlri.parseNlriData_LabelIPv4IPv6(isIPv4, buffer, peerInfo, false);
                break;
            }
            case 128: {
                this.vpnWithdrawn = MultiprotocolReachableNlri.parseNlriData_LabelIPv4IPv6(isIPv4, buffer, peerInfo, true);
                break;
            }
            default: {
                LOG.info("MP_UNREACH AFI=ipv4/ipv6 ({}) SAFI={} is not implemented yet, skipping for now", (Object)isIPv4, (Object)this.safi);
            }
        }
    }

    @Override
    public void accept(Attribute.Visitor visitor) {
        visitor.visit(this);
    }
}

