/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Set;
import org.jivesoftware.smack.PacketCollector;
import org.jivesoftware.smack.RosterEntry;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.RosterPacket;
import org.jivesoftware.smack.util.StringUtils;

public class RosterGroup {
    private String name;
    private XMPPConnection connection;
    private final Set<RosterEntry> entries;

    RosterGroup(String name, XMPPConnection connection) {
        this.name = name;
        this.connection = connection;
        this.entries = new LinkedHashSet<RosterEntry>();
    }

    public String getName() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setName(String name) throws SmackException.NotConnectedException {
        Set<RosterEntry> set = this.entries;
        synchronized (set) {
            for (RosterEntry entry : this.entries) {
                RosterPacket packet = new RosterPacket();
                packet.setType(IQ.Type.SET);
                RosterPacket.Item item = RosterEntry.toRosterItem(entry);
                item.removeGroupName(this.name);
                item.addGroupName(name);
                packet.addRosterItem(item);
                this.connection.sendPacket(packet);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getEntryCount() {
        Set<RosterEntry> set = this.entries;
        synchronized (set) {
            return this.entries.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<RosterEntry> getEntries() {
        Set<RosterEntry> set = this.entries;
        synchronized (set) {
            return Collections.unmodifiableList(new ArrayList<RosterEntry>(this.entries));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RosterEntry getEntry(String user) {
        if (user == null) {
            return null;
        }
        user = StringUtils.parseBareAddress(user);
        String userLowerCase = user.toLowerCase(Locale.US);
        Set<RosterEntry> set = this.entries;
        synchronized (set) {
            for (RosterEntry entry : this.entries) {
                if (!entry.getUser().equals(userLowerCase)) continue;
                return entry;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(RosterEntry entry) {
        Set<RosterEntry> set = this.entries;
        synchronized (set) {
            return this.entries.contains(entry);
        }
    }

    public boolean contains(String user) {
        return this.getEntry(user) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEntry(RosterEntry entry) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        PacketCollector collector = null;
        Set<RosterEntry> set = this.entries;
        synchronized (set) {
            if (!this.entries.contains(entry)) {
                RosterPacket packet = new RosterPacket();
                packet.setType(IQ.Type.SET);
                RosterPacket.Item item = RosterEntry.toRosterItem(entry);
                item.addGroupName(this.getName());
                packet.addRosterItem(item);
                collector = this.connection.createPacketCollectorAndSend(packet);
            }
        }
        if (collector != null) {
            collector.nextResultOrThrow();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeEntry(RosterEntry entry) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        PacketCollector collector = null;
        Set<RosterEntry> set = this.entries;
        synchronized (set) {
            if (this.entries.contains(entry)) {
                RosterPacket packet = new RosterPacket();
                packet.setType(IQ.Type.SET);
                RosterPacket.Item item = RosterEntry.toRosterItem(entry);
                item.removeGroupName(this.getName());
                packet.addRosterItem(item);
                collector = this.connection.createPacketCollectorAndSend(packet);
            }
        }
        if (collector != null) {
            collector.nextResultOrThrow();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addEntryLocal(RosterEntry entry) {
        Set<RosterEntry> set = this.entries;
        synchronized (set) {
            this.entries.remove(entry);
            this.entries.add(entry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeEntryLocal(RosterEntry entry) {
        Set<RosterEntry> set = this.entries;
        synchronized (set) {
            if (this.entries.contains(entry)) {
                this.entries.remove(entry);
            }
        }
    }
}

