/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.grpc.exporter.spog;

import java.util.List;
import java.util.Objects;
import org.opennms.features.grpc.exporter.spog.SpogInventoryService;
import org.opennms.netmgt.dao.api.NodeDao;
import org.opennms.netmgt.events.api.EventListener;
import org.opennms.netmgt.events.api.EventSubscriptionService;
import org.opennms.netmgt.events.api.model.IEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InventoryExporter
implements EventListener {
    private static final Logger LOG = LoggerFactory.getLogger(InventoryExporter.class);
    private final EventSubscriptionService eventSubscriptionService;
    private final NodeDao nodeDao;
    private final SpogInventoryService inventoryService;

    public InventoryExporter(EventSubscriptionService eventSubscriptionService, NodeDao nodeDao, SpogInventoryService inventoryService) {
        this.eventSubscriptionService = Objects.requireNonNull(eventSubscriptionService);
        this.nodeDao = Objects.requireNonNull(nodeDao);
        this.inventoryService = Objects.requireNonNull(inventoryService);
    }

    public void start() {
        this.eventSubscriptionService.addEventListener((EventListener)this, List.of("uei.opennms.org/nodes/nodeGainedService", "uei.opennms.org/nodes/serviceDeleted", "uei.opennms.org/nodes/interfaceDeleted", "uei.opennms.org/nodes/interfaceReparented", "uei.opennms.org/nodes/nodeDeleted"));
    }

    public void stop() {
        this.eventSubscriptionService.removeEventListener((EventListener)this);
    }

    public String getName() {
        return InventoryExporter.class.getName();
    }

    public void onEvent(IEvent event) {
        LOG.debug("Received with event with uei : {} and id {}", (Object)event.getUei(), (Object)event.getDbid());
        switch (event.getUei()) {
            case "uei.opennms.org/nodes/nodeGainedService": 
            case "uei.opennms.org/nodes/serviceDeleted": 
            case "uei.opennms.org/nodes/interfaceDeleted": {
                if (event.getNodeid() == null) {
                    return;
                }
                this.inventoryService.sendAddNmsInventory(event.getNodeid());
                break;
            }
            default: {
                this.inventoryService.sendSnapshot();
            }
        }
    }
}

