/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.grpc.exporter.mapper;

import java.net.InetAddress;
import java.util.List;
import org.opennms.features.grpc.exporter.mapper.AlarmMapper;
import org.opennms.integration.api.v1.runtime.RuntimeInfo;
import org.opennms.netmgt.model.OnmsAlarm;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.monitoringLocations.OnmsMonitoringLocation;
import org.opennms.plugin.grpc.proto.spog.Alarm;
import org.opennms.plugin.grpc.proto.spog.AlarmUpdateList;
import org.opennms.plugin.grpc.proto.spog.NodeCriteria;

public class AlarmMapperImpl
implements AlarmMapper {
    @Override
    public Alarm toAlarmUpdate(OnmsAlarm onmsAlarm) {
        String hostAddress;
        if (onmsAlarm == null) {
            return null;
        }
        Alarm.Builder alarm = Alarm.newBuilder();
        if (onmsAlarm.getCounter() != null) {
            alarm.setCount(onmsAlarm.getCounter().intValue());
        }
        if (onmsAlarm.getLogMsg() != null) {
            alarm.setLogMessage(onmsAlarm.getLogMsg());
        }
        if (onmsAlarm.getOperInstruct() != null) {
            alarm.setOperatorInstructions(onmsAlarm.getOperInstruct());
        }
        if (onmsAlarm.getManagedObjectInstance() != null) {
            alarm.setManagedObjectInstance(onmsAlarm.getManagedObjectInstance());
        }
        if (onmsAlarm.getManagedObjectType() != null) {
            alarm.setManagedObjectType(onmsAlarm.getManagedObjectType());
        }
        if ((hostAddress = this.onmsAlarmIpAddrHostAddress(onmsAlarm)) != null) {
            alarm.setIpAddress(hostAddress);
        }
        if (onmsAlarm.getId() != null) {
            alarm.setId(onmsAlarm.getId().intValue());
        }
        if (onmsAlarm.getUei() != null) {
            alarm.setUei(onmsAlarm.getUei());
        }
        if (onmsAlarm.getReductionKey() != null) {
            alarm.setReductionKey(onmsAlarm.getReductionKey());
        }
        if (onmsAlarm.getDescription() != null) {
            alarm.setDescription(onmsAlarm.getDescription());
        }
        if (onmsAlarm.getAckUser() != null) {
            alarm.setAckUser(onmsAlarm.getAckUser());
        }
        if (onmsAlarm.getAckTime() != null) {
            alarm.setAckTime(this.mapDate(onmsAlarm.getAckTime()));
        }
        if (onmsAlarm.getIfIndex() != null) {
            alarm.setIfIndex(this.mapType(onmsAlarm.getIfIndex()));
        }
        if (onmsAlarm.getClearKey() != null) {
            alarm.setClearKey(onmsAlarm.getClearKey());
        }
        alarm.setLastEventTime(this.mapDate(onmsAlarm.getLastEventTime()));
        alarm.setFirstEventTime(this.mapDate(onmsAlarm.getFirstEventTime()));
        alarm.setLastUpdateTime(this.mapDate(onmsAlarm.getLastUpdateTime()));
        alarm.setType(this.mapType(onmsAlarm.getType().getId()));
        alarm.setNodeCriteria(this.mapNodeCriteria(onmsAlarm));
        alarm.setSeverity(this.mapSeverity(onmsAlarm.getSeverity().toString()));
        return alarm.build();
    }

    @Override
    public AlarmUpdateList toAlarmUpdates(List<OnmsAlarm> onmsAlarmUpdates, RuntimeInfo runtimeInfo, String instanceName, boolean snapshot) {
        if (onmsAlarmUpdates == null && runtimeInfo == null && instanceName == null) {
            return null;
        }
        AlarmUpdateList.Builder alarmUpdateList = AlarmUpdateList.newBuilder();
        if (runtimeInfo != null && runtimeInfo.getSystemId() != null) {
            alarmUpdateList.setInstanceId(runtimeInfo.getSystemId());
        }
        if (onmsAlarmUpdates != null) {
            for (OnmsAlarm onmsAlarmUpdate : onmsAlarmUpdates) {
                alarmUpdateList.addAlarms(this.toAlarmUpdate(onmsAlarmUpdate));
            }
        }
        if (instanceName != null) {
            alarmUpdateList.setInstanceName(instanceName);
        }
        alarmUpdateList.setSnapshot(snapshot);
        return alarmUpdateList.build();
    }

    @Override
    public NodeCriteria mapNodeCriteria(OnmsAlarm alarm) {
        String foreignSource;
        String foreignId;
        String locationName;
        if (alarm == null) {
            return null;
        }
        NodeCriteria.Builder nodeCriteria = NodeCriteria.newBuilder();
        if (alarm.getNodeLabel() != null) {
            nodeCriteria.setNodeLabel(alarm.getNodeLabel());
        }
        if ((locationName = this.alarmNodeLocationLocationName(alarm)) != null) {
            nodeCriteria.setLocation(locationName);
        }
        if ((foreignId = this.alarmNodeForeignId(alarm)) != null) {
            nodeCriteria.setForeignId(foreignId);
        }
        if ((foreignSource = this.alarmNodeForeignSource(alarm)) != null) {
            nodeCriteria.setForeignSource(foreignSource);
        }
        if (alarm.getNodeId() != null) {
            nodeCriteria.setId(alarm.getNodeId().intValue());
        }
        return nodeCriteria.build();
    }

    private String onmsAlarmIpAddrHostAddress(OnmsAlarm onmsAlarm) {
        if (onmsAlarm == null) {
            return null;
        }
        InetAddress ipAddr = onmsAlarm.getIpAddr();
        if (ipAddr == null) {
            return null;
        }
        String hostAddress = ipAddr.getHostAddress();
        if (hostAddress == null) {
            return null;
        }
        return hostAddress;
    }

    private String alarmNodeLocationLocationName(OnmsAlarm onmsAlarm) {
        if (onmsAlarm == null) {
            return null;
        }
        OnmsNode node = onmsAlarm.getNode();
        if (node == null) {
            return null;
        }
        OnmsMonitoringLocation location = node.getLocation();
        if (location == null) {
            return null;
        }
        String locationName = location.getLocationName();
        if (locationName == null) {
            return null;
        }
        return locationName;
    }

    private String alarmNodeForeignId(OnmsAlarm onmsAlarm) {
        if (onmsAlarm == null) {
            return null;
        }
        OnmsNode node = onmsAlarm.getNode();
        if (node == null) {
            return null;
        }
        String foreignId = node.getForeignId();
        if (foreignId == null) {
            return null;
        }
        return foreignId;
    }

    private String alarmNodeForeignSource(OnmsAlarm onmsAlarm) {
        if (onmsAlarm == null) {
            return null;
        }
        OnmsNode node = onmsAlarm.getNode();
        if (node == null) {
            return null;
        }
        String foreignSource = node.getForeignSource();
        if (foreignSource == null) {
            return null;
        }
        return foreignSource;
    }
}

