/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.shaded.jasper.com.lowagie.text.pdf.parser;

import java.io.IOException;
import org.opennms.shaded.jasper.com.lowagie.text.pdf.PdfDictionary;
import org.opennms.shaded.jasper.com.lowagie.text.pdf.PdfName;
import org.opennms.shaded.jasper.com.lowagie.text.pdf.PdfReader;
import org.opennms.shaded.jasper.com.lowagie.text.pdf.RandomAccessFileOrArray;
import org.opennms.shaded.jasper.com.lowagie.text.pdf.parser.SimpleTextExtractingPdfContentStreamProcessor;

public class PdfTextExtractor {
    private final PdfReader reader;
    private final SimpleTextExtractingPdfContentStreamProcessor extractionProcessor;

    public PdfTextExtractor(PdfReader pdfReader) {
        this.reader = pdfReader;
        this.extractionProcessor = new SimpleTextExtractingPdfContentStreamProcessor();
    }

    private byte[] getContentBytesForPage(int n) throws IOException {
        RandomAccessFileOrArray randomAccessFileOrArray = this.reader.getSafeFile();
        byte[] byArray = this.reader.getPageContent(n, randomAccessFileOrArray);
        randomAccessFileOrArray.close();
        return byArray;
    }

    public String getTextFromPage(int n) throws IOException {
        PdfDictionary pdfDictionary = this.reader.getPageN(n);
        PdfDictionary pdfDictionary2 = pdfDictionary.getAsDict(PdfName.RESOURCES);
        this.extractionProcessor.processContent(this.getContentBytesForPage(n), pdfDictionary2);
        return this.extractionProcessor.getResultantText();
    }
}

