/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.charts.fill;

import java.util.HashMap;
import java.util.Map;
import net.sf.jasperreports.charts.JRXyzDataset;
import net.sf.jasperreports.charts.JRXyzSeries;
import net.sf.jasperreports.charts.fill.JRFillXyzSeries;
import net.sf.jasperreports.charts.util.DefaultXYZDataset;
import net.sf.jasperreports.engine.JRExpressionCollector;
import net.sf.jasperreports.engine.JRPrintHyperlink;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.design.JRVerifier;
import net.sf.jasperreports.engine.fill.JRCalculator;
import net.sf.jasperreports.engine.fill.JRExpressionEvalException;
import net.sf.jasperreports.engine.fill.JRFillChartDataset;
import net.sf.jasperreports.engine.fill.JRFillObjectFactory;
import net.sf.jasperreports.engine.util.Pair;
import org.opennms.shaded.jasper.org.jfree.data.general.Dataset;

public class JRFillXyzDataset
extends JRFillChartDataset
implements JRXyzDataset {
    public static final String EXCEPTION_MESSAGE_KEY_SERIES_NULL_NAME = "charts.xyz.dataset.series.null.name";
    protected JRFillXyzSeries[] xyzSeries;
    private DefaultXYZDataset dataset;
    private Map<Comparable<?>, Map<Pair, JRPrintHyperlink>> itemHyperlinks;

    public JRFillXyzDataset(JRXyzDataset xyzDataset, JRFillObjectFactory factory) {
        super(xyzDataset, factory);
        JRXyzSeries[] srcXyzSeries = xyzDataset.getSeries();
        if (srcXyzSeries != null && srcXyzSeries.length > 0) {
            this.xyzSeries = new JRFillXyzSeries[srcXyzSeries.length];
            for (int i = 0; i < this.xyzSeries.length; ++i) {
                this.xyzSeries[i] = (JRFillXyzSeries)factory.getXyzSeries(srcXyzSeries[i]);
            }
        }
    }

    @Override
    public JRXyzSeries[] getSeries() {
        return this.xyzSeries;
    }

    @Override
    protected void customInitialize() {
        this.dataset = new DefaultXYZDataset();
        this.itemHyperlinks = new HashMap();
    }

    @Override
    protected void customEvaluate(JRCalculator calculator) throws JRExpressionEvalException {
        if (this.xyzSeries != null && this.xyzSeries.length > 0) {
            for (int i = 0; i < this.xyzSeries.length; ++i) {
                this.xyzSeries[i].evaluate(calculator);
            }
        }
    }

    @Override
    protected void customIncrement() {
        if (this.xyzSeries != null && this.xyzSeries.length > 0) {
            for (int i = 0; i < this.xyzSeries.length; ++i) {
                JRFillXyzSeries crtXyzSeries = this.xyzSeries[i];
                Comparable<?> seriesName = crtXyzSeries.getSeries();
                if (seriesName == null) {
                    throw new JRRuntimeException(EXCEPTION_MESSAGE_KEY_SERIES_NULL_NAME, (Object[])null);
                }
                this.dataset.addValue(crtXyzSeries.getSeries(), crtXyzSeries.getXValue(), crtXyzSeries.getYValue(), crtXyzSeries.getZValue());
                if (!crtXyzSeries.hasItemHyperlinks()) continue;
                Map<Pair, JRPrintHyperlink> seriesLinks = this.itemHyperlinks.get(crtXyzSeries.getSeries());
                if (seriesLinks == null) {
                    seriesLinks = new HashMap<Pair, JRPrintHyperlink>();
                    this.itemHyperlinks.put(crtXyzSeries.getSeries(), seriesLinks);
                }
                Pair<Number, Number> xyKey = new Pair<Number, Number>(crtXyzSeries.getXValue(), crtXyzSeries.getYValue());
                seriesLinks.put(xyKey, crtXyzSeries.getPrintItemHyperlink());
            }
        }
    }

    @Override
    public Object getLabelGenerator() {
        return null;
    }

    @Override
    public Dataset getCustomDataset() {
        return this.dataset;
    }

    @Override
    public byte getDatasetType() {
        return 4;
    }

    @Override
    public void collectExpressions(JRExpressionCollector collector) {
        collector.collect(this);
    }

    public boolean hasItemHyperlinks() {
        boolean foundLinks = false;
        if (this.xyzSeries != null && this.xyzSeries.length > 0) {
            for (int i = 0; i < this.xyzSeries.length && !foundLinks; ++i) {
                JRFillXyzSeries serie = this.xyzSeries[i];
                foundLinks = serie.hasItemHyperlinks();
            }
        }
        return foundLinks;
    }

    public Map<Comparable<?>, Map<Pair, JRPrintHyperlink>> getItemHyperlinks() {
        return this.itemHyperlinks;
    }

    @Override
    public void validate(JRVerifier verifier) {
        verifier.verify(this);
    }
}

