/*
 * Decompiled with CFR 0.152.
 */
package com.eclipsesource.jaxrs.consumer.internal;

import com.eclipsesource.jaxrs.consumer.ConsumerFactory;
import com.eclipsesource.jaxrs.consumer.ConsumerPublisher;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.List;
import javax.ws.rs.core.Configuration;
import org.glassfish.jersey.client.ClientConfig;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

public class ConsumerPublisherImpl
implements ConsumerPublisher {
    private final BundleContext context;
    private final List<ServiceRegistration> registrations = new ArrayList<ServiceRegistration>();

    public ConsumerPublisherImpl(BundleContext context) {
        this.context = context;
    }

    @Override
    public void publishConsumers(String baseUrl, Class<?>[] types, Object[] providers) {
        for (Class<?> type : types) {
            ClientConfig config = new ClientConfig();
            this.registerProviders(config, providers);
            Object resource = ConsumerFactory.createConsumer(baseUrl, (Configuration)config, type);
            Hashtable<String, String> properties = new Hashtable<String, String>();
            ((Dictionary)properties).put("com.eclipsesource.jaxrs.publish", "false");
            ServiceRegistration registration = this.context.registerService(type.getName(), resource, properties);
            this.registrations.add(registration);
        }
    }

    private void registerProviders(ClientConfig config, Object[] providers) {
        if (providers != null) {
            for (Object provider : providers) {
                config.register(provider);
            }
        }
    }

    public void unregister() {
        for (ServiceRegistration registration : this.registrations) {
            registration.unregister();
        }
    }
}

