/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.vaadin.extender.internal.extender;

import com.vaadin.server.UIProvider;
import com.vaadin.ui.UI;
import java.io.IOException;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.opennms.vaadin.extender.ApplicationFactory;
import org.opennms.vaadin.extender.internal.extender.PaxVaadinBundleTracker;
import org.opennms.vaadin.extender.internal.servlet.OSGiUIProvider;
import org.opennms.vaadin.extender.internal.servlet.VaadinOSGiServlet;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApplicationFactoryServiceTracker
extends ServiceTracker<ApplicationFactory, ApplicationFactory> {
    private Map<ApplicationFactory, ServiceRegistration> m_serviceRegistration = new HashMap<ApplicationFactory, ServiceRegistration>();
    private final Logger logger = LoggerFactory.getLogger((String)ApplicationFactoryServiceTracker.class.getName());
    private final OSGiUIProvider uiProvider = new OSGiUIProvider();

    public ApplicationFactoryServiceTracker(BundleContext context) {
        super(context, ApplicationFactory.class.getName(), null);
    }

    public ApplicationFactory addingService(ServiceReference reference) {
        ApplicationFactory factory = (ApplicationFactory)super.addingService(reference);
        if (factory == null) {
            return null;
        }
        FactoryServlet servlet = new FactoryServlet(this.uiProvider, factory, reference.getBundle().getBundleContext());
        Properties props = new Properties();
        for (String key : reference.getPropertyKeys()) {
            ((Dictionary)props).put(key, reference.getProperty(key));
        }
        if (((Dictionary)props).get("alias") != null && ((Dictionary)props).get("osgi.http.whiteboard.servlet.pattern") == null) {
            this.logger.warn("{} is deprecated. Please use {} instead. For now I am going to do that for you", (Object)"alias", (Object)"osgi.http.whiteboard.servlet.pattern");
            ((Dictionary)props).put("osgi.http.whiteboard.servlet.pattern", ((Dictionary)props).get("alias"));
        }
        if (((Dictionary)props).get("osgi.http.whiteboard.servlet.pattern") == null) {
            this.logger.warn("You have not set the {} property for ApplicationFactory: {}", (Object)"osgi.http.whiteboard.servlet.pattern", (Object)factory);
        }
        if (((Dictionary)props).get("init.widgetset") != null) {
            this.logger.warn("Property {} is deprecated. Please use {} instead. For now I am going to do that for you", (Object)"init.widgetset", (Object)"servlet.init.widgetset");
            ((Dictionary)props).put("servlet.init.widgetset", ((Dictionary)props).get("init.widgetset"));
        }
        if (((Dictionary)props).get("servlet.init.widgetset") != null) {
            this.logger.debug("Widgetset configured to be used: {}", ((Dictionary)props).get("servlet.init.widgetset"));
        } else {
            String widgetset = PaxVaadinBundleTracker.findWidgetset(reference.getBundle());
            if (widgetset != null) {
                this.logger.debug("Widgetset found: {}", (Object)widgetset);
                ((Dictionary)props).put("servlet.init.widgetset", widgetset);
            }
        }
        Class<? extends UI> uiClass = factory.getUIClass();
        if (uiClass == null) {
            throw new IllegalStateException("Cannot register ApplicationFactory as getUIClass() returned null");
        }
        ((Dictionary)props).put("servlet.init.ui.class", uiClass.getCanonicalName());
        this.logger.debug("Found factory for ui class {}, with the following headers {} and service properties {}.", new Object[]{uiClass, factory.getAdditionalHeaders(), props});
        this.m_serviceRegistration.put(factory, this.context.registerService(Servlet.class.getName(), (Object)servlet, (Dictionary)props));
        this.uiProvider.addApplicationFactory(factory);
        return factory;
    }

    public void modifiedService(ServiceReference reference, ApplicationFactory service) {
        super.modifiedService(reference, (Object)service);
    }

    public void removedService(ServiceReference reference, ApplicationFactory service) {
        ApplicationFactory factory = (ApplicationFactory)this.context.getService(reference);
        ServiceRegistration servletRegistration = this.m_serviceRegistration.remove(factory);
        if (servletRegistration != null) {
            servletRegistration.unregister();
        }
        this.uiProvider.removeApplicationFactory(factory);
        super.removedService(reference, (Object)service);
    }

    private class FactoryServlet
    extends VaadinOSGiServlet {
        private static final long serialVersionUID = 7458986273769030388L;
        private ApplicationFactory m_factory;

        public FactoryServlet(UIProvider uiProvider, ApplicationFactory factory, BundleContext context) {
            super(uiProvider, context);
            this.m_factory = factory;
        }

        protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
            Map<String, String> headers = this.m_factory.getAdditionalHeaders();
            if (headers.size() > 0) {
                for (Map.Entry<String, String> entry : headers.entrySet()) {
                    response.addHeader(entry.getKey(), entry.getValue());
                }
            }
            super.service(request, response);
        }
    }
}

