/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.search.providers.action;

import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.opennms.netmgt.config.kscReports.Report;
import org.opennms.netmgt.search.api.QueryUtils;
import org.opennms.netmgt.search.api.SearchContext;
import org.opennms.netmgt.search.api.SearchProvider;
import org.opennms.netmgt.search.api.SearchQuery;
import org.opennms.netmgt.search.api.SearchResult;
import org.opennms.netmgt.search.api.SearchResultItem;
import org.opennms.web.svclayer.api.KscReportService;

public class KscReportSearchProvider
implements SearchProvider {
    private final SearchContext CONTEXT = new SearchContext("KSC Report");
    private final KscReportService kscReportService;

    public SearchContext getContext() {
        return this.CONTEXT;
    }

    public KscReportSearchProvider(KscReportService kscReportService) {
        this.kscReportService = Objects.requireNonNull(kscReportService);
    }

    public SearchResult query(SearchQuery query) {
        Collection reportList = this.kscReportService.getReportMap().values();
        List results = reportList.stream().filter(report -> QueryUtils.matches((String)report.getTitle(), (String)query.getInput())).sorted(Comparator.comparing(Report::getTitle)).map(report -> {
            SearchResultItem result = new SearchResultItem();
            result.setLabel(report.getTitle());
            result.setIdentifier(report.getTitle());
            result.setUrl("KSC/customView.htm?type=custom&report=" + report.getId());
            return result;
        }).limit(query.getMaxResults()).collect(Collectors.toList());
        SearchResult searchResult = new SearchResult(this.CONTEXT).withMore(reportList, results).withResults(results);
        return searchResult;
    }
}

