/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.netty4;

import io.netty.channel.Channel;
import io.netty.channel.ChannelInitializer;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.Processor;
import org.apache.camel.component.netty4.ClientModeTCPNettyServerBootstrapFactory;
import org.apache.camel.component.netty4.DefaultServerInitializerFactory;
import org.apache.camel.component.netty4.NettyConfiguration;
import org.apache.camel.component.netty4.NettyConsumerExceptionHandler;
import org.apache.camel.component.netty4.NettyEndpoint;
import org.apache.camel.component.netty4.NettyServerBootstrapConfiguration;
import org.apache.camel.component.netty4.NettyServerBootstrapFactory;
import org.apache.camel.component.netty4.ServerInitializerFactory;
import org.apache.camel.component.netty4.SingleTCPNettyServerBootstrapFactory;
import org.apache.camel.component.netty4.SingleUDPNettyServerBootstrapFactory;
import org.apache.camel.impl.DefaultConsumer;
import org.apache.camel.util.ServiceHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettyConsumer
extends DefaultConsumer {
    private static final Logger LOG = LoggerFactory.getLogger(NettyConsumer.class);
    private CamelContext context = this.getEndpoint().getCamelContext();
    private NettyConfiguration configuration;
    private NettyServerBootstrapFactory nettyServerBootstrapFactory;

    public NettyConsumer(NettyEndpoint nettyEndpoint, Processor processor, NettyConfiguration configuration) {
        super((Endpoint)nettyEndpoint, processor);
        this.configuration = configuration;
        this.setNettyServerBootstrapFactory(configuration.getNettyServerBootstrapFactory());
        this.setExceptionHandler(new NettyConsumerExceptionHandler(this));
    }

    public NettyEndpoint getEndpoint() {
        return (NettyEndpoint)super.getEndpoint();
    }

    protected void doStart() throws Exception {
        super.doStart();
        LOG.debug("Netty consumer binding to: {}", (Object)this.configuration.getAddress());
        if (this.nettyServerBootstrapFactory == null) {
            ServerInitializerFactory factory = this.configuration.getServerInitializerFactory();
            ServerInitializerFactory pipelineFactory = factory != null ? factory.createPipelineFactory(this) : new DefaultServerInitializerFactory(this);
            this.nettyServerBootstrapFactory = this.isTcp() ? (this.configuration.isClientMode() ? new ClientModeTCPNettyServerBootstrapFactory() : new SingleTCPNettyServerBootstrapFactory()) : new SingleUDPNettyServerBootstrapFactory();
            this.nettyServerBootstrapFactory.init(this.context, (NettyServerBootstrapConfiguration)this.configuration, (ChannelInitializer<Channel>)pipelineFactory);
        }
        ServiceHelper.startServices((Object[])new Object[]{this.nettyServerBootstrapFactory});
        LOG.info("Netty consumer bound to: " + this.configuration.getAddress());
    }

    protected void doStop() throws Exception {
        LOG.debug("Netty consumer unbinding from: {}", (Object)this.configuration.getAddress());
        ServiceHelper.stopService((Object)this.nettyServerBootstrapFactory);
        LOG.info("Netty consumer unbound from: " + this.configuration.getAddress());
        super.doStop();
    }

    public CamelContext getContext() {
        return this.context;
    }

    public NettyConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(NettyConfiguration configuration) {
        this.configuration = configuration;
    }

    public NettyServerBootstrapFactory getNettyServerBootstrapFactory() {
        return this.nettyServerBootstrapFactory;
    }

    public void setNettyServerBootstrapFactory(NettyServerBootstrapFactory nettyServerBootstrapFactory) {
        this.nettyServerBootstrapFactory = nettyServerBootstrapFactory;
    }

    protected boolean isTcp() {
        return this.configuration.getProtocol().equalsIgnoreCase("tcp");
    }
}

