/*
 * Decompiled with CFR 0.152.
 */
package org.sblim.slp.internal.ua;

import java.net.DatagramPacket;
import java.util.Arrays;
import java.util.HashSet;

public class ResponseCache {
    private HashSet iResponseSet = new HashSet();

    public void add(DatagramPacket pPacket) {
        this.iResponseSet.add(new Entry(pPacket));
    }

    public boolean contains(DatagramPacket pPacket) {
        return this.iResponseSet.contains(new Entry(pPacket));
    }

    private static class Entry {
        private byte[] iData;
        private int iHashCode;

        public Entry(byte[] pData, int pOffset, int pLength) {
            this.iData = new byte[pLength];
            System.arraycopy(pData, pOffset, this.iData, 0, pLength);
            for (int pos = 0; pos < this.iData.length; ++pos) {
                this.iHashCode <<= 4;
                this.iHashCode += this.iData[pos] & 0xFF;
            }
        }

        public Entry(DatagramPacket pPacket) {
            this(pPacket.getData(), pPacket.getOffset(), pPacket.getLength());
        }

        public int hashCode() {
            return this.iHashCode;
        }

        public boolean equals(Object pObj) {
            if (this == pObj) {
                return true;
            }
            Entry that = (Entry)pObj;
            return this.iHashCode == that.iHashCode && Arrays.equals(this.iData, that.iData);
        }
    }
}

