/*
 * Decompiled with CFR 0.152.
 */
package io.pkts.framer;

import io.pkts.buffer.Buffer;
import io.pkts.framer.Framer;
import io.pkts.packet.IPPacket;
import io.pkts.packet.TCPPacket;
import io.pkts.packet.impl.TcpPacketImpl;
import io.pkts.protocol.Protocol;
import java.io.IOException;

public final class TCPFramer
implements Framer<IPPacket, TCPPacket> {
    @Override
    public Protocol getProtocol() {
        return Protocol.TCP;
    }

    @Override
    public TCPPacket frame(IPPacket parent, Buffer buffer) throws IOException {
        if (parent == null) {
            throw new IllegalArgumentException("The parent frame cannot be null");
        }
        Buffer headers = buffer.readBytes(20);
        Buffer options = null;
        Buffer payload = null;
        byte offset = headers.getByte(12);
        int size = (offset >> 4 & 0xF) - 5;
        if (size > 0) {
            options = buffer.readBytes(size * 4);
        }
        if (buffer.hasReadableBytes()) {
            payload = buffer.slice();
        }
        return new TcpPacketImpl(parent, headers, options, payload);
    }

    @Override
    public boolean accept(Buffer data) throws IOException {
        return false;
    }
}

