/*
 * Decompiled with CFR 0.152.
 */
package jcifs.internal.smb2.io;

import jcifs.Configuration;
import jcifs.internal.SMBProtocolDecodingException;
import jcifs.internal.smb2.ServerMessageBlock2Response;
import jcifs.internal.util.SMBUtil;

public class Smb2WriteResponse
extends ServerMessageBlock2Response {
    private int count;
    private int remaining;

    public Smb2WriteResponse(Configuration config) {
        super(config);
    }

    public final int getCount() {
        return this.count;
    }

    public final int getRemaining() {
        return this.remaining;
    }

    @Override
    protected int writeBytesWireFormat(byte[] dst, int dstIndex) {
        return 0;
    }

    @Override
    protected int readBytesWireFormat(byte[] buffer, int bufferIndex) throws SMBProtocolDecodingException {
        int start = bufferIndex;
        int structureSize = SMBUtil.readInt2(buffer, bufferIndex);
        if (structureSize != 17) {
            throw new SMBProtocolDecodingException("Expected structureSize = 17");
        }
        this.count = SMBUtil.readInt4(buffer, bufferIndex += 4);
        this.remaining = SMBUtil.readInt4(buffer, bufferIndex += 4);
        bufferIndex += 4;
        return (bufferIndex += 4) - start;
    }
}

