/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.collectd;

import java.net.InetAddress;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.management.ObjectName;
import org.opennms.core.mate.api.Interpolator;
import org.opennms.core.spring.BeanUtils;
import org.opennms.core.utils.AlphaNumeric;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.core.utils.ParameterMap;
import org.opennms.netmgt.collectd.JMXDataSource;
import org.opennms.netmgt.collectd.JMXNodeInfo;
import org.opennms.netmgt.collection.api.AbstractRemoteServiceCollector;
import org.opennms.netmgt.collection.api.CollectionAgent;
import org.opennms.netmgt.collection.api.CollectionSet;
import org.opennms.netmgt.collection.api.ServiceParameters;
import org.opennms.netmgt.collection.support.NumericAttributeUtils;
import org.opennms.netmgt.collection.support.builder.CollectionSetBuilder;
import org.opennms.netmgt.collection.support.builder.DeferredGenericTypeResource;
import org.opennms.netmgt.collection.support.builder.NodeLevelResource;
import org.opennms.netmgt.collection.support.builder.Resource;
import org.opennms.netmgt.config.JMXDataCollectionConfigDao;
import org.opennms.netmgt.config.collectd.jmx.Attrib;
import org.opennms.netmgt.config.collectd.jmx.JmxCollection;
import org.opennms.netmgt.config.collectd.jmx.Mbean;
import org.opennms.netmgt.config.jmx.MBeanServer;
import org.opennms.netmgt.dao.jmx.JmxConfigDao;
import org.opennms.netmgt.jmx.JmxCollectorConfig;
import org.opennms.netmgt.jmx.JmxSampleProcessor;
import org.opennms.netmgt.jmx.JmxUtils;
import org.opennms.netmgt.jmx.connection.JmxConnectors;
import org.opennms.netmgt.jmx.impl.DefaultJmxCollector;
import org.opennms.netmgt.jmx.samples.AbstractJmxSample;
import org.opennms.netmgt.jmx.samples.JmxAttributeSample;
import org.opennms.netmgt.jmx.samples.JmxCompositeSample;
import org.opennms.netmgt.rrd.RrdRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JMXCollector
extends AbstractRemoteServiceCollector {
    private static final Logger LOG = LoggerFactory.getLogger(JMXCollector.class);
    private static final String JMX_COLLECTION_KEY = "jmxCollection";
    private static final String JMX_MBEAN_SERVER_KEY = "jmxMBeanServer";
    private static final Map<String, Class<?>> TYPE_MAP = Collections.unmodifiableMap(Stream.of(new AbstractMap.SimpleEntry<String, Class<JmxCollection>>("jmxCollection", JmxCollection.class), new AbstractMap.SimpleEntry<String, Class<MBeanServer>>("jmxMBeanServer", MBeanServer.class)).collect(Collectors.toMap(e -> (String)e.getKey(), e -> (Class)e.getValue())));
    private JmxConfigDao m_jmxConfigDao;
    private JMXDataCollectionConfigDao m_jmxDataCollectionConfigDao;
    private String serviceName = null;

    public JMXCollector() {
        super(TYPE_MAP);
    }

    public String serviceName() {
        return this.serviceName.toUpperCase();
    }

    public void setServiceName(String name) {
        this.serviceName = name;
    }

    public void initialize() {
        if (this.m_jmxDataCollectionConfigDao == null) {
            this.m_jmxDataCollectionConfigDao = (JMXDataCollectionConfigDao)BeanUtils.getBean((String)"daoContext", (String)"jmxDataCollectionConfigDao", JMXDataCollectionConfigDao.class);
        }
        if (this.m_jmxConfigDao == null) {
            this.m_jmxConfigDao = (JmxConfigDao)BeanUtils.getBean((String)"daoContext", (String)"jmxConfigDao", JmxConfigDao.class);
        }
    }

    public Map<String, Object> getRuntimeAttributes(CollectionAgent agent, Map<String, Object> parameters) {
        HashMap<String, Object> runtimeAttributes = new HashMap<String, Object>();
        String collectionName = ParameterMap.getKeyedString(parameters, (String)ServiceParameters.ParameterName.COLLECTION.toString(), (String)this.serviceName);
        JmxCollection jmxCollection = this.m_jmxDataCollectionConfigDao.getJmxCollection(collectionName);
        if (jmxCollection == null) {
            throw new IllegalArgumentException(String.format("JMXCollector: No collection found with name '%s'.", collectionName));
        }
        runtimeAttributes.put(JMX_COLLECTION_KEY, Interpolator.pleaseInterpolate((Object)jmxCollection));
        HashMap<String, String> parameterStringMap = new HashMap<String, String>();
        for (Map.Entry<String, Object> eachEntry : parameters.entrySet()) {
            if (!(eachEntry.getValue() instanceof String)) continue;
            parameterStringMap.put(eachEntry.getKey(), (String)eachEntry.getValue());
        }
        MBeanServer mBeanServer = JmxUtils.getMBeanServer((JmxConfigDao)this.m_jmxConfigDao, (String)agent.getHostAddress(), parameterStringMap);
        if (mBeanServer != null) {
            runtimeAttributes.put(JMX_MBEAN_SERVER_KEY, Interpolator.pleaseInterpolate((Object)mBeanServer));
        }
        return runtimeAttributes;
    }

    protected JmxConnectors getConnectionName() {
        return JmxConnectors.DEFAULT;
    }

    public CollectionSet collect(CollectionAgent agent, Map<String, Object> map) {
        final Map stringMap = JmxUtils.convertToUnmodifiableStringMap(map);
        InetAddress ipaddr = agent.getAddress();
        JmxCollection jmxCollection = (JmxCollection)map.get(JMX_COLLECTION_KEY);
        MBeanServer mBeanServer = (MBeanServer)map.get(JMX_MBEAN_SERVER_KEY);
        String collectionName = ParameterMap.getKeyedString(map, (String)ServiceParameters.ParameterName.COLLECTION.toString(), (String)this.serviceName);
        String port = ParameterMap.getKeyedString(map, (String)ServiceParameters.ParameterName.PORT.toString(), null);
        String friendlyName = ParameterMap.getKeyedString(map, (String)ServiceParameters.ParameterName.FRIENDLY_NAME.toString(), (String)port);
        String collDir = JmxUtils.getCollectionDirectory((Map)stringMap, (String)friendlyName, (String)this.serviceName);
        int retries = ParameterMap.getKeyedInteger(map, (String)ServiceParameters.ParameterName.RETRY.toString(), (int)3);
        InetAddress ipAddr = agent.getAddress();
        int nodeID = agent.getNodeId();
        String hostAddress = InetAddressUtils.str((InetAddress)ipAddr);
        LOG.debug("initialize: InetAddress={}, collectionName={}", (Object)hostAddress, (Object)collectionName);
        final JMXNodeInfo nodeInfo = new JMXNodeInfo(nodeID);
        LOG.debug("nodeInfo: {} {} {}", new Object[]{hostAddress, nodeID, agent});
        Map attrMap = JMXDataCollectionConfigDao.getAttributeMap((JmxCollection)jmxCollection, (String)this.serviceName(), (String)hostAddress);
        nodeInfo.setAttributeMap(attrMap);
        Map<String, JMXDataSource> dsList = JMXCollector.buildDataSourceList(collectionName, attrMap);
        nodeInfo.setDsMap(dsList);
        nodeInfo.setMBeans(JMXDataCollectionConfigDao.getMBeanInfo((JmxCollection)jmxCollection));
        final NodeLevelResource nodeResource = new NodeLevelResource(agent.getNodeId(), collDir);
        final NodeLevelResource parentResource = new NodeLevelResource(agent.getNodeId());
        final CollectionSetBuilder collectionSetBuilder = new CollectionSetBuilder(agent);
        LOG.debug("connecting to {} on node ID {}", (Object)InetAddressUtils.str((InetAddress)ipaddr), (Object)nodeInfo.getNodeId());
        try {
            JmxCollectorConfig config = new JmxCollectorConfig();
            config.setAgentAddress(InetAddressUtils.str((InetAddress)ipaddr));
            config.setConnectionName(this.getConnectionName());
            config.setRetries(retries);
            config.setServiceProperties(stringMap);
            config.setJmxCollection(jmxCollection);
            DefaultJmxCollector jmxCollector = new DefaultJmxCollector();
            jmxCollector.collect(config, mBeanServer, new JmxSampleProcessor(){

                public void process(JmxAttributeSample attributeSample, ObjectName objectName) {
                    String mbeanObjectName = attributeSample.getMbean().getObjectname();
                    String attributeName = attributeSample.getCollectedAttribute().getName();
                    String dsKey = mbeanObjectName + "|" + attributeName;
                    JMXDataSource ds = nodeInfo.getDsMap().get(dsKey);
                    if (ds == null) {
                        LOG.info("Could not find datasource for {}. Skipping.", (Object)dsKey);
                        return;
                    }
                    String resourceType = attributeSample.getMbean().getResourceType();
                    if (resourceType != null) {
                        String parsedObjectName = JMXCollector.fixGroupName(objectName.getCanonicalName());
                        DeferredGenericTypeResource resource = new DeferredGenericTypeResource(parentResource, resourceType, parsedObjectName);
                        this.addNumericAttributeToCollectionSet(ds, (AbstractJmxSample)attributeSample, (Resource)resource);
                        this.addStringAttributesToCollectionSet(ds, (AbstractJmxSample)attributeSample, (Resource)resource, objectName);
                    } else {
                        this.addNumericAttributeToCollectionSet(ds, (AbstractJmxSample)attributeSample, (Resource)nodeResource);
                    }
                }

                public void process(JmxCompositeSample compositeSample, ObjectName objectName) {
                    String mbeanObjectName = compositeSample.getMbean().getObjectname();
                    String attributeName = compositeSample.getCollectedAttribute().getName();
                    String dsKey = mbeanObjectName + "|" + attributeName + "|" + compositeSample.getCompositeKey();
                    JMXDataSource ds = nodeInfo.getDsMap().get(dsKey);
                    if (ds == null) {
                        LOG.info("Could not find datasource for {}. Skipping.", (Object)dsKey);
                        return;
                    }
                    String resourceType = compositeSample.getMbean().getResourceType();
                    if (resourceType != null) {
                        String parsedObjectName = JMXCollector.fixGroupName(objectName.getCanonicalName());
                        DeferredGenericTypeResource resource = new DeferredGenericTypeResource(parentResource, resourceType, parsedObjectName);
                        this.addNumericAttributeToCollectionSet(ds, (AbstractJmxSample)compositeSample, (Resource)resource);
                        this.addStringAttributesToCollectionSet(ds, (AbstractJmxSample)compositeSample, (Resource)resource, objectName);
                    } else {
                        this.addNumericAttributeToCollectionSet(ds, (AbstractJmxSample)compositeSample, (Resource)nodeResource);
                    }
                }

                private void addStringAttributesToCollectionSet(JMXDataSource ds, AbstractJmxSample sample, Resource resource, ObjectName objectName) {
                    String groupName = JMXCollector.fixGroupName(JmxUtils.getGroupName((Map)stringMap, (Mbean)sample.getMbean()));
                    String domain = objectName.getDomain();
                    Hashtable<String, String> properties = objectName.getKeyPropertyList();
                    properties.forEach((key, value) -> collectionSetBuilder.withStringAttribute(resource, groupName, key, value));
                    if (domain != null) {
                        collectionSetBuilder.withStringAttribute(resource, groupName, "domain", objectName.getDomain());
                    }
                }

                private void addNumericAttributeToCollectionSet(JMXDataSource ds, AbstractJmxSample sample, Resource resource) {
                    String groupName = JMXCollector.fixGroupName(JmxUtils.getGroupName((Map)stringMap, (Mbean)sample.getMbean()));
                    String valueAsString = sample.getCollectedValueAsString();
                    Double value = NumericAttributeUtils.parseNumericValue((String)valueAsString);
                    String metricId = groupName;
                    metricId = metricId.replace("_type_", ":type=");
                    metricId = metricId.replace("_", ".");
                    metricId = metricId.concat(".");
                    metricId = metricId.concat(ds.getName());
                    metricId = "JMX_".concat(metricId);
                    collectionSetBuilder.withIdentifiedNumericAttribute(resource, groupName, ds.getName(), (Number)value, ds.getType(), metricId);
                }
            });
        }
        catch (Exception e) {
            LOG.debug("{} Collector.collect: IOException while collecting address: {}", new Object[]{this.serviceName, agent.getAddress(), e});
        }
        return collectionSetBuilder.build();
    }

    private static String fixGroupName(String objectName) {
        if (objectName == null) {
            return "NULL";
        }
        return AlphaNumeric.parseAndReplace((String)objectName, (char)'_');
    }

    protected static Map<String, JMXDataSource> buildDataSourceList(String collectionName, Map<String, List<Attrib>> attributeMap) {
        LOG.debug("buildDataSourceList - ***");
        HashMap<String, JMXDataSource> dsList = new HashMap<String, JMXDataSource>();
        LOG.debug("attributeMap size: {}", (Object)attributeMap.size());
        for (String objectName : attributeMap.keySet()) {
            List<Attrib> list = attributeMap.get(objectName);
            LOG.debug("ObjectName: {}, Attributes: {}", (Object)objectName, (Object)list.size());
            for (Attrib attr : list) {
                if (attr.getType().isNumeric()) {
                    JMXDataSource ds = new JMXDataSource();
                    ds.setName(attr.getAlias());
                    ds.setType(attr.getType());
                    LOG.debug("buildDataSourceList: ds_name: {} ds_type: {}", (Object)ds.getName(), (Object)ds.getType());
                    dsList.put(objectName + "|" + attr.getName(), ds);
                    continue;
                }
                LOG.warn("buildDataSourceList: Data type '{}' not supported.  Only integer-type data may be stored in RRD.  MBean object '{}' will not be mapped to RRD data source.", (Object)attr.getType(), (Object)attr.getAlias());
            }
        }
        return dsList;
    }

    public RrdRepository getRrdRepository(String collectionName) {
        return this.m_jmxDataCollectionConfigDao.getRrdRepository(collectionName);
    }

    public void setJmxConfigDao(JmxConfigDao jmxConfigDao) {
        this.m_jmxConfigDao = Objects.requireNonNull(jmxConfigDao);
    }

    public void setJmxDataCollectionConfigDao(JMXDataCollectionConfigDao jmxDataCollectionConfigDao) {
        this.m_jmxDataCollectionConfigDao = Objects.requireNonNull(jmxDataCollectionConfigDao);
    }
}

