/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.telemetry.protocols.bmp.parser.proto.bgp.packets.pathattr;

import com.google.common.collect.Lists;
import io.netty.buffer.ByteBuf;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.telemetry.listeners.utils.BufferUtils;
import org.opennms.netmgt.telemetry.protocols.bmp.parser.InvalidPacketException;
import org.opennms.netmgt.telemetry.protocols.bmp.parser.proto.bgp.packets.UpdatePacket;
import org.opennms.netmgt.telemetry.protocols.bmp.parser.proto.bgp.packets.pathattr.Attribute;
import org.opennms.netmgt.telemetry.protocols.bmp.parser.proto.bmp.PeerFlags;
import org.opennms.netmgt.telemetry.protocols.bmp.parser.proto.bmp.PeerInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiprotocolReachableNlri
implements Attribute {
    public static final Logger LOG = LoggerFactory.getLogger(MultiprotocolReachableNlri.class);
    static final int BGP_AFI_IPV4 = 1;
    static final int BGP_AFI_IPV6 = 2;
    static final int BGP_AFI_L2VPN = 25;
    static final int BGP_AFI_BGPLS = 16388;
    static final int BGP_SAFI_UNICAST = 1;
    static final int BGP_SAFI_MULTICAST = 2;
    static final int BGP_SAFI_NLRI_LABEL = 4;
    static final int BGP_SAFI_MCAST_VPN = 5;
    static final int BGP_SAFI_VPLS = 65;
    static final int BGP_SAFI_MDT = 66;
    static final int BGP_SAFI_4over6 = 67;
    static final int BGP_SAFI_6over4 = 68;
    static final int BGP_SAFI_EVPN = 70;
    static final int BGP_SAFI_BGPLS = 71;
    static final int BGP_SAFI_MPLS = 128;
    static final int BGP_SAFI_MCAST_MPLS_VPN = 129;
    static final int BGP_SAFI_RT_CONSTRAINS = 132;
    static final int PREFIX_UNICAST_V4 = 1;
    static final int PREFIX_UNICAST_V6 = 2;
    static final int PREFIX_LABEL_UNICAST_V4 = 3;
    static final int PREFIX_LABEL_UNICAST_V6 = 4;
    static final int PREFIX_VPN_V4 = 5;
    static final int PREFIX_VPN_v6 = 6;
    static final int PREFIX_MULTICAST_V4 = 7;
    static final int NLRI_TYPE_NODE = 1;
    static final int NLRI_TYPE_LINK = 2;
    static final int NLRI_TYPE_IPV4_PREFIX = 3;
    static final int NLRI_TYPE_IPV6_PREFIX = 4;
    public final int afi;
    public final int safi;
    public int length;
    public byte[] nextHopBytes;
    public InetAddress nextHop;
    public List<UpdatePacket.Prefix> advertised = Lists.newArrayList();
    public List<UpdatePacket.Prefix> vpnAdvertised = Lists.newArrayList();

    public MultiprotocolReachableNlri(ByteBuf buffer, PeerFlags flags, Optional<PeerInfo> peerInfo) throws InvalidPacketException {
        this.afi = BufferUtils.uint16((ByteBuf)buffer);
        this.safi = BufferUtils.uint8((ByteBuf)buffer);
        this.length = BufferUtils.uint8((ByteBuf)buffer);
        this.nextHopBytes = BufferUtils.bytes((ByteBuf)buffer, (int)this.length);
        BufferUtils.skip((ByteBuf)buffer, (int)1);
        try {
            this.parseAfi(buffer, peerInfo);
        }
        catch (UnknownHostException ex) {
            throw new InvalidPacketException(buffer, "Error parsing IP address", ex);
        }
        catch (Exception ex) {
            throw new InvalidPacketException(buffer, "Error parsing packet", ex);
        }
    }

    void parseAfi(ByteBuf buffer, Optional<PeerInfo> peerInfo) throws Exception {
        switch (this.afi) {
            case 2: {
                this.parseAfi_IPv4IPv6(false, buffer, peerInfo);
                break;
            }
            case 1: {
                this.parseAfi_IPv4IPv6(true, buffer, peerInfo);
                break;
            }
            case 16388: {
                this.nextHop = InetAddressUtils.getInetAddress((byte[])this.nextHopBytes);
                LOG.info("MP_REACH AFI=bgp-ls SAFI={} is not implemented yet, skipping for now", (Object)this.safi);
                break;
            }
            case 25: {
                this.nextHop = this.nextHopBytes.length > 16 ? InetAddressUtils.getInetAddress((byte[])Arrays.copyOf(this.nextHopBytes, 16)) : InetAddressUtils.getInetAddress((byte[])this.nextHopBytes);
                LOG.info("EVPN AFI=bgp_afi_l2vpn SAFI={} is not implemented yet, skipping", (Object)this.safi);
                break;
            }
            default: {
                LOG.info("MP_REACH AFI={} is not implemented yet, skipping", (Object)this.afi);
            }
        }
    }

    void parseAfi_IPv4IPv6(boolean isIPv4, ByteBuf buffer, Optional<PeerInfo> peerInfo) throws Exception {
        switch (this.safi) {
            case 1: {
                this.nextHop = this.nextHopBytes.length > 16 ? InetAddressUtils.getInetAddress((byte[])Arrays.copyOf(this.nextHopBytes, 16)) : InetAddressUtils.getInetAddress((byte[])this.nextHopBytes);
                this.advertised = MultiprotocolReachableNlri.parseNlriData_IPv4IPv6(isIPv4, buffer, peerInfo);
                break;
            }
            case 4: {
                this.nextHop = this.nextHopBytes.length > 16 ? InetAddressUtils.getInetAddress((byte[])Arrays.copyOf(this.nextHopBytes, 16)) : InetAddressUtils.getInetAddress((byte[])this.nextHopBytes);
                this.advertised = MultiprotocolReachableNlri.parseNlriData_LabelIPv4IPv6(isIPv4, buffer, peerInfo, false);
                break;
            }
            case 128: {
                if (isIPv4) {
                    this.length -= 8;
                    byte[] bytes = new byte[4];
                    System.arraycopy(this.nextHopBytes, 8, bytes, 0, 4);
                    this.nextHopBytes = bytes;
                }
                this.nextHop = this.nextHopBytes.length != 4 ? InetAddressUtils.getInetAddress((byte[])Arrays.copyOf(this.nextHopBytes, 16)) : InetAddressUtils.getInetAddress((byte[])this.nextHopBytes);
                this.vpnAdvertised = MultiprotocolReachableNlri.parseNlriData_LabelIPv4IPv6(isIPv4, buffer, peerInfo, true);
                break;
            }
            default: {
                LOG.info("MP_REACH AFI=ipv4/ipv6 ({}) SAFI={} is not implemented yet, skipping for now", (Object)isIPv4, (Object)this.safi);
            }
        }
    }

    static List<UpdatePacket.Prefix> parseNlriData_IPv4IPv6(boolean isIPv4, ByteBuf buffer, Optional<PeerInfo> peerInfo) {
        boolean addPathCapabilityEnabled = peerInfo.map(info -> info.isAddPathEnabled(isIPv4 ? 1 : 2, 1)).orElse(false);
        return BufferUtils.repeatRemaining((ByteBuf)buffer, b -> {
            UpdatePacket.Prefix tuple = new UpdatePacket.Prefix();
            if (addPathCapabilityEnabled) {
                tuple.pathId = BufferUtils.uint32((ByteBuf)b);
            }
            tuple.length = BufferUtils.uint8((ByteBuf)b);
            int byteCount = tuple.length / 8 + (tuple.length % 8 > 0 ? 1 : 0);
            byte[] prefixBytes = BufferUtils.bytes((ByteBuf)b, (int)byteCount);
            tuple.prefix = isIPv4 ? InetAddressUtils.getInetAddress((byte[])Arrays.copyOf(prefixBytes, 4)) : InetAddressUtils.getInetAddress((byte[])Arrays.copyOf(prefixBytes, 16));
            return tuple;
        });
    }

    static List<UpdatePacket.Prefix> parseNlriData_LabelIPv4IPv6(boolean isIPv4, ByteBuf buffer, Optional<PeerInfo> peerInfo, boolean isVPN) throws Exception {
        boolean addPathCapabilityEnabled = peerInfo.map(info -> info.isAddPathEnabled(isIPv4 ? 1 : 2, isVPN ? 128 : 4)).orElse(false);
        return BufferUtils.repeatRemaining((ByteBuf)buffer, b -> {
            UpdatePacket.Prefix tuple = new UpdatePacket.Prefix();
            tuple.pathId = addPathCapabilityEnabled && !isVPN && b.readableBytes() >= 4 ? BufferUtils.uint32((ByteBuf)b) : 0L;
            tuple.length = BufferUtils.uint8((ByteBuf)b);
            int byteCount = tuple.length / 8 + (tuple.length % 8 > 0 ? 1 : 0);
            List<String> labels = MultiprotocolReachableNlri.decodeLabel(b);
            tuple.labels = String.join((CharSequence)",", labels);
            tuple.length -= 24 * labels.size();
            if (isVPN && (byteCount -= labels.size() * 3) >= 8) {
                int type = BufferUtils.uint16((ByteBuf)b);
                switch (type) {
                    case 0: {
                        BufferUtils.skip((ByteBuf)b, (int)6);
                        break;
                    }
                    case 1: {
                        BufferUtils.skip((ByteBuf)b, (int)6);
                        break;
                    }
                    case 2: {
                        BufferUtils.skip((ByteBuf)b, (int)6);
                    }
                }
                byteCount -= 8;
                tuple.length -= 64;
            }
            if (byteCount > 0) {
                byte[] prefixBytes = BufferUtils.bytes((ByteBuf)b, (int)byteCount);
                tuple.prefix = isIPv4 ? InetAddressUtils.getInetAddress((byte[])Arrays.copyOf(prefixBytes, 4)) : InetAddressUtils.getInetAddress((byte[])Arrays.copyOf(prefixBytes, 16));
            } else {
                tuple.prefix = InetAddressUtils.addr((String)(isIPv4 ? "0.0.0.0" : "::"));
            }
            return tuple;
        });
    }

    private static List<String> decodeLabel(ByteBuf buffer) {
        ArrayList<String> labels = new ArrayList<String>();
        while (buffer.readableBytes() > 0) {
            int data = BufferUtils.uint24((ByteBuf)buffer) & 0xFFFFF;
            int label = data >> 4;
            int exp = (data & 0xE) >> 1;
            int bos = data & 1;
            labels.add(String.valueOf(label));
            if (bos != 1 && data != Integer.MIN_VALUE && data != 0) continue;
            break;
        }
        return labels;
    }

    @Override
    public void accept(Attribute.Visitor visitor) {
        visitor.visit(this);
    }
}

