/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.telemetry.protocols.netflow.parser.ipfix.proto;

import com.google.common.base.MoreObjects;
import io.netty.buffer.ByteBuf;
import java.util.Optional;
import org.opennms.netmgt.telemetry.listeners.utils.BufferUtils;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.InvalidPacketException;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.MissingTemplateException;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.Protocol;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.ie.InformationElement;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.ie.InformationElementDatabase;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.ie.Value;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.ie.values.UndeclaredValue;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.session.Field;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.session.Scope;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.session.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FieldSpecifier
implements Field,
Scope {
    private static final Logger LOG = LoggerFactory.getLogger(FieldSpecifier.class);
    public final int informationElementId;
    public final int fieldLength;
    public final Optional<Long> enterpriseNumber;
    public final InformationElement informationElement;

    public FieldSpecifier(ByteBuf buffer) throws InvalidPacketException {
        int elementId = BufferUtils.uint16((ByteBuf)buffer);
        this.informationElementId = elementId & Short.MAX_VALUE;
        this.fieldLength = BufferUtils.uint16((ByteBuf)buffer);
        if ((elementId & 0x8000) == 0) {
            this.enterpriseNumber = Optional.empty();
        } else {
            long enterpriseNumber = BufferUtils.uint32((ByteBuf)buffer);
            this.enterpriseNumber = Optional.of(enterpriseNumber);
        }
        this.informationElement = InformationElementDatabase.instance.lookup(Protocol.IPFIX, this.enterpriseNumber, this.informationElementId).orElseGet(() -> {
            LOG.warn("Undeclared information element: {}", (Object)UndeclaredValue.nameFor(this.enterpriseNumber, this.informationElementId));
            return UndeclaredValue.parser(this.enterpriseNumber, this.informationElementId);
        });
        if (this.fieldLength > this.informationElement.getMaximumFieldLength() || this.fieldLength < this.informationElement.getMinimumFieldLength()) {
            throw new InvalidPacketException(buffer, "Template field '%s' has illegal size: %d (min=%d, max=%d)", this.informationElement.getName(), this.fieldLength, this.informationElement.getMinimumFieldLength(), this.informationElement.getMaximumFieldLength());
        }
    }

    @Override
    public Value<?> parse(Session.Resolver resolver, ByteBuf buffer) throws InvalidPacketException, MissingTemplateException {
        try {
            return this.informationElement.parse(resolver, buffer);
        }
        catch (InvalidPacketException e) {
            throw new InvalidPacketException(e, "Failed to parse IPFix information element: enterpriseNumber=%s informationElementId=%d", this.enterpriseNumber, this.informationElementId);
        }
    }

    @Override
    public int length() {
        return this.fieldLength;
    }

    @Override
    public String getName() {
        return this.informationElement.getName();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("informationElementId", this.informationElementId).add("enterpriseNumber", this.enterpriseNumber).add("fieldLength", this.fieldLength).toString();
    }
}

