/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.service;

import java.io.Serializable;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlValue;
import org.opennms.core.xml.ValidateUsing;
import org.opennms.netmgt.config.utils.ConfigUtils;

@XmlRootElement(name="value")
@XmlAccessorType(value=XmlAccessType.FIELD)
@ValidateUsing(value="service-configuration.xsd")
public class Value
implements Serializable {
    private static final long serialVersionUID = 2L;
    @XmlValue
    private String m_content;
    @XmlAttribute(name="type", required=true)
    private String m_type;

    public Value() {
    }

    public Value(String type, String content) {
        this.setType(type);
        this.setContent(content);
    }

    public String getContent() {
        return this.m_content;
    }

    public void setContent(String content) {
        this.m_content = ConfigUtils.normalizeString(content);
    }

    public String getType() {
        return this.m_type;
    }

    public void setType(String type) {
        this.m_type = ConfigUtils.assertNotEmpty(type, "type");
    }

    public int hashCode() {
        return Objects.hash(this.m_content, this.m_type);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Value) {
            Value that = (Value)obj;
            return Objects.equals(this.m_content, that.m_content) && Objects.equals(this.m_type, that.m_type);
        }
        return false;
    }
}

