/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.integration.api.sample;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.stream.Collectors;
import org.opennms.integration.api.v1.graph.Graph;
import org.opennms.integration.api.v1.graph.GraphContainer;
import org.opennms.integration.api.v1.graph.GraphContainerInfo;
import org.opennms.integration.api.v1.graph.GraphContainerProvider;
import org.opennms.integration.api.v1.graph.GraphInfo;
import org.opennms.integration.api.v1.graph.Vertex;
import org.opennms.integration.api.v1.graph.configuration.GraphCacheStrategy;
import org.opennms.integration.api.v1.graph.configuration.GraphConfiguration;
import org.opennms.integration.api.v1.graph.configuration.TopologyConfiguration;
import org.opennms.integration.api.v1.graph.immutables.ImmutableEdge;
import org.opennms.integration.api.v1.graph.immutables.ImmutableGraph;
import org.opennms.integration.api.v1.graph.immutables.ImmutableGraphContainer;
import org.opennms.integration.api.v1.graph.immutables.ImmutableGraphContainerInfo;
import org.opennms.integration.api.v1.graph.immutables.ImmutableGraphInfo;
import org.opennms.integration.api.v1.graph.immutables.ImmutableVertex;
import org.opennms.integration.api.v1.graph.immutables.ImmutableVertexRef;

public class MyGraphContainerProvider
implements GraphContainerProvider {
    public static final String NAMESPACE_1 = "1";
    public static final String NAMESPACE_2 = "2";

    public GraphContainer loadGraphContainer() {
        GraphContainerInfo graphContainerInfo = this.getGraphContainerInfo();
        ImmutableGraphContainer.Builder containerBuilder = ImmutableGraphContainer.newBuilder((GraphContainerInfo)graphContainerInfo);
        ImmutableGraph.Builder graphBuilderA = ImmutableGraph.newBuilder((GraphInfo)graphContainerInfo.getGraphInfo(NAMESPACE_1));
        ArrayList<ImmutableVertex> vertices = new ArrayList<ImmutableVertex>(Arrays.asList(graphBuilderA.vertex("v1").label("Vertex 1").nodeRef("test", "node1").iconId("database").build(), graphBuilderA.vertex("v2").label("Vertex 2").nodeRef("test", "node2").iconId("vmware-hostsystem-off").build(), graphBuilderA.vertex("v3").label("Vertex 3").iconId("interface").build()));
        graphBuilderA.addVertices(vertices);
        ArrayList<ImmutableEdge> edges = new ArrayList<ImmutableEdge>(Arrays.asList(graphBuilderA.edge("e1", ImmutableVertexRef.newBuilder((String)NAMESPACE_1, (String)"v1").build(), ImmutableVertexRef.newBuilder((String)NAMESPACE_1, (String)"v2").build()).build(), graphBuilderA.edge("e2", ImmutableVertexRef.newBuilder((String)NAMESPACE_1, (String)"v2").build(), ImmutableVertexRef.newBuilder((String)NAMESPACE_1, (String)"v3").build()).build()));
        graphBuilderA.addEdges(edges);
        graphBuilderA.defaultFocus(ImmutableVertexRef.newBuilder((String)NAMESPACE_1, (String)"v1").build());
        ImmutableGraph.Builder graphBuilderB = ImmutableGraph.newBuilder((GraphInfo)graphContainerInfo.getGraphInfo(NAMESPACE_2));
        ArrayList<String> iconKeys = new ArrayList<String>(Arrays.asList("business_service", "server", "cloud", "printer", "switch", "situation", "IP_service", "market_1"));
        for (int i = 0; i < iconKeys.size(); ++i) {
            ImmutableVertex vertex = graphBuilderB.vertex("v" + (i + 1)).label("Vertex " + (i + 1)).iconId((String)iconKeys.get(i)).build();
            graphBuilderB.addVertex((Vertex)vertex);
        }
        graphBuilderB.defaultFocus(graphBuilderB.getVertices().stream().map(ImmutableVertexRef::immutableCopy).collect(Collectors.toList()));
        containerBuilder.addGraph((Graph)graphBuilderA.build());
        containerBuilder.addGraph((Graph)graphBuilderB.build());
        return containerBuilder.build();
    }

    public GraphContainerInfo getGraphContainerInfo() {
        return ImmutableGraphContainerInfo.newBuilder((String)"my-container", (String)"Example Graph Provider", (String)"This is an example graph provider", (GraphInfo[])new GraphInfo[]{ImmutableGraphInfo.newBuilder((String)NAMESPACE_1, (String)"Graph 1", (String)"This is the first Graph within the Example Graph Provider").build(), ImmutableGraphInfo.newBuilder((String)NAMESPACE_2, (String)"Graph 2", (String)"This is the second Graph within the Example Graph Provider").build()}).build();
    }

    public GraphConfiguration getGraphConfiguration() {
        return new GraphConfiguration(){

            public GraphConfiguration.GraphStatusStrategy getGraphStatusStrategy() {
                return GraphConfiguration.GraphStatusStrategy.Custom;
            }

            public boolean shouldEnrichNodeInfo() {
                return true;
            }

            public GraphCacheStrategy getGraphCacheStrategy() {
                return GraphCacheStrategy.FOREVER;
            }
        };
    }

    public TopologyConfiguration getTopologyConfiguration() {
        return new TopologyConfiguration(){

            public TopologyConfiguration.LegacyStatusStrategy getLegacyStatusStrategy() {
                return TopologyConfiguration.LegacyStatusStrategy.Custom;
            }

            public boolean isLegacyTopology() {
                return true;
            }

            public boolean shouldResolveNodes() {
                return true;
            }
        };
    }
}

