/*
 * Decompiled with CFR 0.152.
 */
package io.hawt.log.osgi;

import io.hawt.log.osgi.LogQuery;
import org.apache.karaf.log.core.LogService;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Activator
implements BundleActivator {
    private transient Logger LOG = LoggerFactory.getLogger(Activator.class);
    private LogQuery logQuery;

    public void start(BundleContext context) throws Exception {
        ServiceReference ref = context.getServiceReference(LogService.class.getName());
        if (ref != null) {
            LogService logService = (LogService)context.getService(ref);
            this.logQuery = new LogQuery(logService);
            this.logQuery.start();
        } else {
            this.LOG.warn("Cannot find OSGi service " + LogService.class.getName() + " to use by hawtio-log to trap into the Karaf logging service");
        }
    }

    public void stop(BundleContext context) throws Exception {
        if (this.logQuery != null) {
            this.logQuery.stop();
        }
    }
}

