/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.telemetry.shell;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.karaf.shell.api.action.Action;
import org.apache.karaf.shell.api.action.Argument;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Completion;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.apache.karaf.shell.support.completers.StringsCompleter;
import org.opennms.netmgt.telemetry.api.TelemetryManager;
import org.opennms.netmgt.telemetry.shell.Format;
import org.opennms.netmgt.telemetry.shell.Utils;

@Command(scope="opennms", name="telemetry-listeners", description="Lists configured telemetry listeners")
@Service
public class Listeners
implements Action {
    @Reference
    public TelemetryManager manager;
    @Argument(index=0, name="listener", description="Filter listeners shown by this RegEx", required=false)
    public String listenerFilter = ".*";
    @Option(name="-f", aliases={"--format"}, description="Dump data in given format", required=false, multiValued=false)
    @Completion(value=StringsCompleter.class, values={"PLAIN", "JSON"})
    public Format format = Format.PLAIN;

    public Object execute() {
        List<JsonObject> output = this.manager.getListeners().stream().filter(listener -> listener.getName().matches(this.listenerFilter)).map(listener -> {
            JsonObject data = new JsonObject();
            data.addProperty("name", listener.getName());
            data.addProperty("description", listener.getDescription());
            data.add("properties", (JsonElement)Utils.getWritableProperties(listener));
            JsonArray parsers = new JsonArray();
            listener.getParsers().forEach(parser -> parsers.add(parser.getName()));
            data.add("parsers", (JsonElement)parsers);
            return data;
        }).collect(Collectors.toList());
        this.format.print(output);
        return null;
    }
}

